/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractMethodReturnsNull;
import com.google.errorprone.dataflow.nullnesspropagation.TrustingNullnessAnalysis;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import java.util.Optional;

@BugPattern(summary="Method has a collection return type and returns {@code null} in some cases but does not annotate the method as @Nullable. See Effective Java 3rd Edition Item 54.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class ReturnsNullCollection
extends AbstractMethodReturnsNull {
    private static final Matcher<MethodTree> METHOD_RETURNS_COLLECTION_WITHOUT_NULLABLE_ANNOTATION = Matchers.allOf(Matchers.anyOf(Matchers.methodReturns(Matchers.isSubtypeOf("java.util.Collection")), Matchers.methodReturns(Matchers.isSubtypeOf("java.util.Map")), Matchers.methodReturns(Matchers.isSubtypeOf("com.google.common.collect.Multimap"))), ReturnsNullCollection::methodWithoutNullable);

    private static boolean methodWithoutNullable(MethodTree tree, VisitorState state) {
        return !TrustingNullnessAnalysis.hasNullableAnnotation(ASTHelpers.getSymbol(tree));
    }

    public ReturnsNullCollection() {
        super(METHOD_RETURNS_COLLECTION_WITHOUT_NULLABLE_ANNOTATION);
    }

    @Override
    protected Optional<Fix> provideFix(ReturnTree tree) {
        return Optional.empty();
    }
}

