/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import java.util.Iterator;
import java.util.Objects;

@BugPattern(summary="reachabilityFence should always be called inside a finally block", severity=BugPattern.SeverityLevel.WARNING)
public class ReachabilityFenceUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> FENCE_MATCHER = MethodMatchers.staticMethod().onClass("java.lang.ref.Reference").named("reachabilityFence");

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!FENCE_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Tree previous = null;
        Iterator<Tree> iterator = state.getPath().getParentPath().iterator();
        while (iterator.hasNext()) {
            Tree enclosing = iterator.next();
            switch (enclosing.getKind()) {
                case TRY: {
                    if (!Objects.equals(((TryTree)enclosing).getFinallyBlock(), previous)) break;
                    return Description.NO_MATCH;
                }
                case CLASS: 
                case METHOD: 
                case LAMBDA_EXPRESSION: {
                    return this.describeMatch(tree);
                }
            }
            previous = enclosing;
        }
        return this.describeMatch(tree);
    }
}

