/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;

@BugPattern(severity=BugPattern.SeverityLevel.ERROR, summary="Comparing protobuf fields of type String using reference equality")
public class ProtoStringFieldReferenceEquality
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final String PROTO_SUPER_CLASS = "com.google.protobuf.GeneratedMessage";
    private static final String LITE_PROTO_SUPER_CLASS = "com.google.protobuf.GeneratedMessageLite";
    private static final Matcher<ExpressionTree> PROTO_STRING_METHOD = Matchers.allOf(Matchers.instanceMethod().onDescendantOfAny("com.google.protobuf.GeneratedMessage", "com.google.protobuf.GeneratedMessageLite"), Matchers.isSameType(Suppliers.STRING_TYPE));

    @Override
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        switch (tree.getKind()) {
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        ExpressionTree lhs = tree.getLeftOperand();
        ExpressionTree rhs = tree.getRightOperand();
        if (ProtoStringFieldReferenceEquality.match(lhs, rhs, state) || ProtoStringFieldReferenceEquality.match(rhs, lhs, state)) {
            Object result = String.format("%s.equals(%s)", state.getSourceForNode(lhs), state.getSourceForNode(rhs));
            if (tree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                result = "!" + (String)result;
            }
            return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree, (String)result));
        }
        return Description.NO_MATCH;
    }

    private static boolean match(ExpressionTree a, ExpressionTree b, VisitorState state) {
        return PROTO_STRING_METHOD.matches(a, state) && b.getKind() != Tree.Kind.NULL_LITERAL;
    }
}

