/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Protected members in final classes can be package-private", severity=BugPattern.SeverityLevel.WARNING)
public class ProtectedMembersInFinalClass
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> HAS_FINAL = Matchers.hasModifier(Modifier.FINAL);
    private static final Matcher<Tree> HAS_PROTECTED = Matchers.hasModifier(Modifier.PROTECTED);

    private static boolean methodHasNoParentMethod(MethodTree methodTree, VisitorState state) {
        return ASTHelpers.findSuperMethods(ASTHelpers.getSymbol(methodTree), state.getTypes()).isEmpty();
    }

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!HAS_FINAL.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ImmutableList<Tree> relevantMembers = tree.getMembers().stream().filter(m4 -> m4 instanceof MethodTree || m4 instanceof VariableTree).filter(m4 -> HAS_PROTECTED.matches((Tree)m4, state)).filter(m4 -> !(m4 instanceof MethodTree) || ProtectedMembersInFinalClass.methodHasNoParentMethod((MethodTree)m4, state)).filter(m4 -> !this.isSuppressed((Tree)m4, state)).collect(ImmutableList.toImmutableList());
        if (relevantMembers.isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        relevantMembers.forEach(m4 -> SuggestedFixes.removeModifiers(m4, state, Modifier.PROTECTED).ifPresent(fix::merge));
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        String message = String.format("Make members of final classes package-private: %s", relevantMembers.stream().map(m4 -> {
            Symbol symbol = ASTHelpers.getSymbol(m4);
            return symbol.isConstructor() ? symbol.owner.name.toString() : symbol.name.toString();
        }).collect(Collectors.joining(", ")));
        return this.buildDescription((Tree)relevantMembers.get(0)).setMessage(message).addFix(fix.build()).build();
    }
}

