/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_PreferredInterfaceType_BetterTypes;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;

@BugPattern(altNames={"MutableConstantField", "MutableMethodReturnType"}, summary="This type can be more specific.", severity=BugPattern.SeverityLevel.WARNING)
public final class PreferredInterfaceType
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final ImmutableList<BetterTypes> BETTER_TYPES = ImmutableList.of(BetterTypes.of(TypePredicates.isDescendantOf("java.lang.Iterable"), "com.google.common.collect.ImmutableSortedSet", "com.google.common.collect.ImmutableSortedMap", "com.google.common.collect.ImmutableSortedMultiset", "com.google.common.collect.ImmutableList", "com.google.common.collect.ImmutableSet", "com.google.common.collect.ImmutableCollection", "java.util.List", "java.util.Set"), BetterTypes.of(TypePredicates.isDescendantOf("java.util.Map"), "com.google.common.collect.ImmutableMap"), BetterTypes.of(TypePredicates.isDescendantOf("com.google.common.collect.Table"), "com.google.common.collect.ImmutableTable"), BetterTypes.of(TypePredicates.isDescendantOf("com.google.common.collect.RangeSet"), "com.google.common.collect.ImmutableRangeSet"), BetterTypes.of(TypePredicates.isDescendantOf("com.google.common.collect.RangeMap"), "com.google.common.collect.ImmutableRangeMap"), BetterTypes.of(TypePredicates.isDescendantOf("com.google.common.collect.Multimap"), "com.google.common.collect.ImmutableListMultimap", "com.google.common.collect.ImmutableSetMultimap", "com.google.common.collect.ImmutableMultimap", "com.google.common.collect.ListMultimap", "com.google.common.collect.SetMultimap"), BetterTypes.of(TypePredicates.isDescendantOf("java.lang.CharSequence"), "java.lang.String"));
    private static final Matcher<Tree> INTERESTING_TYPE = Matchers.anyOf(BETTER_TYPES.stream().map(bt -> Matchers.typePredicateMatcher(bt.predicate())).collect(ImmutableList.toImmutableList()));
    public static final Matcher<Tree> SHOULD_IGNORE = Matchers.anyOf(InjectMatchers.hasProvidesAnnotation(), Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.isType("com.google.inject.testing.fieldbinder.Bind"))));
    private static final String IMMUTABLE_MESSAGE = " type should use the immutable type (such as ImmutableList) instead of the general collection interface type (such as List).";
    private static final String NON_IMMUTABLE_MESSAGE = " type can use a more specific type to convey more information to callers.";
    private static final String OVERRIDE_NOTE = " Note that it is possible to return a more specific type even when overriding a method.";

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        final ImmutableMap<Symbol, Tree> fixableTypes = this.getFixableTypes(state);
        final ArrayListMultimap<Symbol, Type> symbolsToType = ArrayListMultimap.create();
        new TreePathScanner<Void, Void>(){
            private final Deque<Symbol> currentMethod = new LinkedList<Symbol>();

            @Override
            public Void visitMethod(MethodTree node, Void unused) {
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(node);
                this.currentMethod.addLast(methodSymbol);
                super.visitMethod(node, null);
                this.currentMethod.removeLast();
                return null;
            }

            @Override
            public Void visitVariable(VariableTree node, Void unused) {
                if (node.getInitializer() != null) {
                    symbolsToType.put(ASTHelpers.getSymbol(node), ASTHelpers.getType(node.getInitializer()));
                }
                return (Void)super.visitVariable(node, null);
            }

            @Override
            public Void visitAssignment(AssignmentTree node, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol(node.getVariable());
                if (fixableTypes.containsKey(symbol)) {
                    symbolsToType.put(symbol, ASTHelpers.getType(node.getExpression()));
                }
                return (Void)super.visitAssignment(node, null);
            }

            @Override
            public Void visitReturn(ReturnTree node, Void unused) {
                Symbol method = this.currentMethod.peekLast();
                if (method != null) {
                    symbolsToType.put(method, ASTHelpers.getType(node.getExpression()));
                }
                return (Void)super.visitReturn(node, unused);
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                this.currentMethod.addLast(null);
                super.visitLambdaExpression(node, unused);
                this.currentMethod.removeLast();
                return null;
            }
        }.scan(state.getPath(), (Void)null);
        this.reportFixes(fixableTypes, symbolsToType, state);
        return Description.NO_MATCH;
    }

    private ImmutableMap<Symbol, Tree> getFixableTypes(VisitorState state) {
        final ImmutableMap.Builder fixableTypes = ImmutableMap.builder();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol(tree);
                if (this.variableIsFixable(tree, symbol)) {
                    fixableTypes.put(symbol, tree.getType());
                }
                return (Void)super.visitVariable(tree, null);
            }

            private boolean variableIsFixable(VariableTree tree, Symbol.VarSymbol symbol) {
                if (symbol == null) {
                    return false;
                }
                if (symbol.getKind() == ElementKind.PARAMETER) {
                    return false;
                }
                if (ASTHelpers.shouldKeep(tree)) {
                    return false;
                }
                if (SHOULD_IGNORE.matches(tree, this.state)) {
                    return false;
                }
                if (symbol.getKind() == ElementKind.FIELD && !ASTHelpers.isConsideredFinal(symbol) && !ASTHelpers.canBeRemoved(symbol)) {
                    return false;
                }
                return Matchers.variableType(INTERESTING_TYPE).matches(tree, this.state);
            }

            @Override
            public Void visitMethod(MethodTree node, Void unused) {
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(node);
                if (Matchers.methodReturns(INTERESTING_TYPE).matches(node, this.state) && !ASTHelpers.methodCanBeOverridden(methodSymbol) && !SHOULD_IGNORE.matches(node, this.state)) {
                    fixableTypes.put(methodSymbol, node.getReturnType());
                }
                return (Void)super.visitMethod(node, null);
            }
        }.scan(state.getPath(), null);
        return fixableTypes.buildOrThrow();
    }

    private void reportFixes(Map<Symbol, Tree> fixableTypes, ListMultimap<Symbol, Type> symbolsToType, VisitorState state) {
        Types types = state.getTypes();
        for (Map.Entry<Symbol, List<Type>> entry : Multimaps.asMap(symbolsToType).entrySet()) {
            Symbol symbol = entry.getKey();
            List<Type> assignedTypes = entry.getValue();
            Tree tree = fixableTypes.get(symbol);
            if (tree == null) continue;
            assignedTypes.stream().filter(type -> !type.getKind().equals((Object)TypeKind.NULL)).map(type -> ASTHelpers.getUpperBound(type, types)).reduce((xva$0, xva$1) -> types.lub((Type)xva$0, (Type)xva$1)).flatMap(type -> PreferredInterfaceType.toGoodReplacement(type, state)).filter(replacement -> !ASTHelpers.isSubtype(ASTHelpers.getType(tree), replacement, state)).filter(replacement -> ASTHelpers.isSubtype(replacement, ASTHelpers.getType(tree), state)).ifPresent(type -> {
                SuggestedFix.Builder builder = SuggestedFix.builder();
                SuggestedFix fix = builder.replace(ASTHelpers.getErasedTypeTree(tree), SuggestedFixes.qualifyType(state, builder, type.asElement())).addImport(types.erasure((Type)type).toString()).build();
                state.reportMatch(this.buildDescription(tree).setMessage(PreferredInterfaceType.getMessage(symbol, type, state)).addFix(fix).build());
            });
        }
    }

    private static String getMessage(Symbol symbol, Type newType, VisitorState state) {
        String messageBase;
        String string = messageBase = !PreferredInterfaceType.isImmutable(PreferredInterfaceType.targetType(symbol)) && PreferredInterfaceType.isImmutable(newType) ? IMMUTABLE_MESSAGE : NON_IMMUTABLE_MESSAGE;
        if (symbol instanceof Symbol.MethodSymbol) {
            if (!ASTHelpers.findSuperMethods((Symbol.MethodSymbol)symbol, state.getTypes()).isEmpty()) {
                return "Method return" + messageBase + OVERRIDE_NOTE;
            }
            return "Method return" + messageBase;
        }
        return "Variable" + messageBase;
    }

    private static Type targetType(Symbol symbol) {
        return symbol instanceof Symbol.MethodSymbol ? ((Symbol.MethodSymbol)symbol).getReturnType() : symbol.type;
    }

    private static boolean isImmutable(Type type) {
        return type.tsym.getQualifiedName().toString().startsWith("com.google.common.collect.Immutable");
    }

    private static Optional<Type> toGoodReplacement(Type type, VisitorState state) {
        return BETTER_TYPES.stream().filter(bt -> bt.predicate().apply(type, state)).map(BetterTypes::betterTypes).findFirst().flatMap(betterTypes -> betterTypes.stream().map(typeName -> Suppliers.typeFromString(typeName).get(state)).filter(sensibleType -> sensibleType != null && ASTHelpers.isSubtype(type, sensibleType, state)).findFirst());
    }

    @AutoValue
    static abstract class BetterTypes {
        BetterTypes() {
        }

        abstract TypePredicate predicate();

        abstract ImmutableSet<String> betterTypes();

        private static BetterTypes of(TypePredicate predicate, String ... betterTypes) {
            return new AutoValue_PreferredInterfaceType_BetterTypes(predicate, ImmutableSet.copyOf(betterTypes));
        }
    }
}

