/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.SuppressPackageLocation;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;

@BugPattern(summary="Package names should match the directory they are declared in", severity=BugPattern.SeverityLevel.SUGGESTION, documentSuppression=false, suppressionAnnotations={SuppressPackageLocation.class}, tags={"Style"}, altNames={"PackageName"})
public class PackageLocation
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    private static final Splitter PATH_SPLITTER = Splitter.on('/');

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        if (tree.getPackageName() == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Tree)tree.getPackage(), SuppressPackageLocation.class, state)) {
            return Description.NO_MATCH;
        }
        Symbol.PackageSymbol packageSymbol = ((JCTree.JCCompilationUnit)state.getPath().getCompilationUnit()).packge;
        if (packageSymbol == null) {
            return Description.NO_MATCH;
        }
        String packageName = packageSymbol.fullname.toString();
        String actualFileName = ASTHelpers.getFileName(tree);
        if (actualFileName == null) {
            return Description.NO_MATCH;
        }
        List<String> actualPath = PATH_SPLITTER.splitToList(actualFileName.substring(0, actualFileName.lastIndexOf(47)));
        List<String> expectedSuffix = DOT_SPLITTER.splitToList(packageName);
        List<String> actualSuffix = actualPath.subList(Math.max(0, actualPath.size() - expectedSuffix.size()), actualPath.size());
        if (actualSuffix.equals(expectedSuffix)) {
            return Description.NO_MATCH;
        }
        String message = String.format("Expected package %s to be declared in a directory ending with %s, instead found %s", packageName, Joiner.on('/').join(expectedSuffix), Joiner.on('/').join(actualSuffix));
        return this.buildDescription(tree.getPackageName()).setMessage(message).build();
    }
}

