/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="To return a custom message with a Throwable class, one should override getMessage() instead of toString().", severity=BugPattern.SeverityLevel.WARNING)
public final class OverrideThrowableToString
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    @Override
    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!ASTHelpers.isSubtype(ASTHelpers.getType(classTree), state.getSymtab().throwableType, state)) {
            return Description.NO_MATCH;
        }
        ImmutableList methods = classTree.getMembers().stream().filter(m4 -> m4 instanceof MethodTree).map(m4 -> (MethodTree)m4).collect(ImmutableList.toImmutableList());
        if (methods.stream().anyMatch(m4 -> m4.getName().contentEquals("getMessage"))) {
            return Description.NO_MATCH;
        }
        return methods.stream().filter(m4 -> Matchers.toStringMethodDeclaration().matches((MethodTree)m4, state)).findFirst().map(m4 -> this.describeMatch((Tree)m4, (Fix)SuggestedFixes.renameMethod(m4, "getMessage", state))).orElse(Description.NO_MATCH);
    }
}

