/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import java.util.IllegalFormatException;
import java.util.MissingFormatArgumentException;

@BugPattern(summary="String literal contains format specifiers, but is not passed to a format method", severity=BugPattern.SeverityLevel.WARNING)
public class OrphanedFormatString
extends BugChecker
implements BugChecker.LiteralTreeMatcher {
    private static final Matcher<Tree> LIKELY_MISTAKE_METHOD_CALL = Matchers.toType(ExpressionTree.class, Matchers.anyOf(MethodMatchers.constructor().forClass("java.lang.StringBuilder"), Matchers.allOf(MethodMatchers.constructor().forClass(TypePredicates.isDescendantOf(s2 -> s2.getSymtab().throwableType)), (tree, state) -> {
        Symbol sym = ASTHelpers.getSymbol(tree);
        return sym instanceof Symbol.MethodSymbol && !((Symbol.MethodSymbol)sym).isVarArgs();
    }), MethodMatchers.instanceMethod().onDescendantOfAny("java.io.PrintStream", "java.io.PrintWriter").namedAnyOf("print", "println"), MethodMatchers.instanceMethod().onExactClass("java.lang.StringBuilder").named("append").withParameters("java.lang.CharSequence", "int", "int"), MethodMatchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertWithMessage").withParameters("java.lang.String", new String[0]), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("log").withParameters("java.lang.String", new String[0]), (t2, s2) -> t2 instanceof MethodInvocationTree && !ASTHelpers.findMatchingMethods(ASTHelpers.getSymbol((Tree)t2).name, ms -> ASTHelpers.hasAnnotation((Symbol)ms, FormatMethod.class, s2) || ms.getParameters().stream().anyMatch(vs -> ASTHelpers.hasAnnotation((Symbol)vs, FormatString.class, s2)), ASTHelpers.getReceiverType(t2), s2.getTypes()).isEmpty()));

    @Override
    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        Object value = tree.getValue();
        if (!(value instanceof String)) {
            return Description.NO_MATCH;
        }
        if (!OrphanedFormatString.missingFormatArgs((String)value)) {
            return Description.NO_MATCH;
        }
        Tree methodInvocation = state.getPath().getParentPath().getLeaf();
        if (!LIKELY_MISTAKE_METHOD_CALL.matches(methodInvocation, state)) {
            return Description.NO_MATCH;
        }
        if (methodInvocation.getKind() == Tree.Kind.METHOD_INVOCATION && OrphanedFormatString.literalIsFormatMethodArg(tree, (MethodInvocationTree)methodInvocation, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static boolean literalIsFormatMethodArg(LiteralTree tree, MethodInvocationTree methodInvocationTree, VisitorState state) {
        int indexOfParam;
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(methodInvocationTree);
        if (ASTHelpers.hasAnnotation((Symbol)symbol, FormatMethod.class, state) && (indexOfParam = OrphanedFormatString.findIndexOfFormatStringParameter(state, symbol)) != -1) {
            java.util.List<? extends ExpressionTree> args = methodInvocationTree.getArguments();
            return args.size() > indexOfParam && args.get(indexOfParam) == tree;
        }
        return false;
    }

    private static int findIndexOfFormatStringParameter(VisitorState state, Symbol.MethodSymbol symbol) {
        int indexOfFirstString = -1;
        List<Symbol.VarSymbol> params = symbol.params();
        for (int i = 0; i < params.size(); ++i) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)params.get(i);
            if (ASTHelpers.hasAnnotation((Symbol)varSymbol, FormatString.class, state)) {
                return i;
            }
            if (indexOfFirstString != -1 || !ASTHelpers.isSameType(varSymbol.type, state.getSymtab().stringType, state)) continue;
            indexOfFirstString = i;
        }
        return indexOfFirstString;
    }

    private static boolean missingFormatArgs(String value) {
        try {
            String string = String.format(value, new Object[0]);
        }
        catch (MissingFormatArgumentException e) {
            return true;
        }
        catch (IllegalFormatException illegalFormatException) {
            // empty catch block
        }
        return false;
    }
}

