/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Optional.ifPresent is preferred over Optional.map when the return value is unused", severity=BugPattern.SeverityLevel.ERROR)
public final class OptionalMapUnusedValue
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> METHOD_IS_OPTIONAL_MAP = MethodMatchers.instanceMethod().onExactClass("java.util.Optional").named("map");
    private static final Matcher<ExpressionTree> PARENT_IS_STATEMENT = Matchers.parentNode(Matchers.kindIs(Tree.Kind.EXPRESSION_STATEMENT));
    private static final Matcher<MethodInvocationTree> ARG_IS_VOID_COMPATIBLE = Matchers.argument(0, Matchers.anyOf(Matchers.kindIs(Tree.Kind.MEMBER_REFERENCE), OptionalMapUnusedValue::isVoidCompatibleLambda));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (METHOD_IS_OPTIONAL_MAP.matches(tree, state) && PARENT_IS_STATEMENT.matches(tree, state) && ARG_IS_VOID_COMPATIBLE.matches(tree, state)) {
            return this.describeMatch(tree, (Fix)SuggestedFixes.renameMethodInvocation(tree, "ifPresent", state));
        }
        return Description.NO_MATCH;
    }

    private static boolean isVoidCompatibleLambda(ExpressionTree tree, VisitorState state) {
        LambdaExpressionTree lambdaTree;
        if (tree instanceof LambdaExpressionTree && (lambdaTree = (LambdaExpressionTree)tree).getBodyKind().equals((Object)LambdaExpressionTree.BodyKind.EXPRESSION)) {
            return Matchers.kindIs(Tree.Kind.METHOD_INVOCATION).matches(lambdaTree.getBody(), state);
        }
        return false;
    }
}

