/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReferenceEquality;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="Comparison using reference equality instead of value equality", severity=BugPattern.SeverityLevel.ERROR)
public class OptionalEquality
extends AbstractReferenceEquality {
    private static final ImmutableSet<String> OPTIONAL_CLASSES = ImmutableSet.of(Optional.class.getName(), "java.util.Optional");

    @Override
    protected boolean matchArgument(ExpressionTree tree, VisitorState state) {
        Type type = ASTHelpers.getType(tree);
        for (String className : OPTIONAL_CLASSES) {
            if (!ASTHelpers.isSameType(type, state.getTypeFromString(className), state)) continue;
            return true;
        }
        return false;
    }
}

