/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Avoid unnecessary boxing by using plain == for primitive types.", tags={"Performance"}, severity=BugPattern.SeverityLevel.WARNING)
public class ObjectEqualsForPrimitives
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> MATCHER = Matchers.allOf(Matchers.staticEqualsInvocation(), Matchers.argument(0, Matchers.isPrimitiveType()), Matchers.argument(1, Matchers.isPrimitiveType()));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        String arg1 = state.getSourceForNode(tree.getArguments().get(0));
        String arg2 = state.getSourceForNode(tree.getArguments().get(1));
        SuggestedFix fix = SuggestedFix.builder().replace(tree, "(" + arg1 + " == " + arg2 + ")").build();
        return this.describeMatch(tree, (Fix)fix);
    }
}

