/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Visibility;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@BugPattern(summary="This type is referred to by a non-canonical name, which may be misleading.", severity=BugPattern.SeverityLevel.WARNING)
public final class NonCanonicalType
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    private static final Pattern PACKAGE_CLASS_NAME_SPLITTER = Pattern.compile("(.*?)\\.([A-Z].*)");

    @Override
    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        if (state.getPath().getParentPath().getLeaf() instanceof MemberSelectTree) {
            return Description.NO_MATCH;
        }
        String canonicalName = NonCanonicalType.canonicalName(tree);
        if (canonicalName == null) {
            return Description.NO_MATCH;
        }
        if (canonicalName.contains("$")) {
            return Description.NO_MATCH;
        }
        String nonCanonicalName = NonCanonicalType.getNonCanonicalName(tree);
        if (canonicalName.equals(nonCanonicalName)) {
            return Description.NO_MATCH;
        }
        Symbol symbol = ASTHelpers.getSymbol(tree);
        while (symbol != null) {
            if (!Visibility.fromModifiers(symbol.getModifiers()).shouldBeVisible(tree, state)) {
                return Description.NO_MATCH;
            }
            symbol = ASTHelpers.enclosingClass(symbol);
        }
        if (ASTHelpers.getStartPosition(tree) == -1) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        SuggestedFix fix = fixBuilder.replace(tree, SuggestedFixes.qualifyType(state, fixBuilder, canonicalName)).build();
        return this.buildDescription(tree).setMessage(NonCanonicalType.createDescription(canonicalName, nonCanonicalName)).addFix(fix).build();
    }

    @Nullable
    private static String canonicalName(MemberSelectTree tree) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        if (sym == null) {
            return null;
        }
        if (!(sym instanceof Symbol.TypeSymbol)) {
            return null;
        }
        Symbol owner = sym.owner;
        if (owner == null) {
            return null;
        }
        return owner.getQualifiedName() + "." + sym.getSimpleName();
    }

    private static String createDescription(String canonicalName, String nonCanonicalName) {
        Matcher canonicalNameMatcher = PACKAGE_CLASS_NAME_SPLITTER.matcher(canonicalName);
        Matcher nonCanonicalNameMatcher = PACKAGE_CLASS_NAME_SPLITTER.matcher(nonCanonicalName);
        if (canonicalNameMatcher.matches() && nonCanonicalNameMatcher.matches() && !canonicalNameMatcher.group(2).equals(nonCanonicalNameMatcher.group(2))) {
            return String.format("The type `%s` was referred to by the non-canonical name `%s`. This may be misleading.", canonicalNameMatcher.group(2), nonCanonicalNameMatcher.group(2));
        }
        return String.format("The type `%s` was referred to by the non-canonical name `%s`. This may be misleading.", canonicalName, nonCanonicalName);
    }

    private static String getNonCanonicalName(Tree tree) {
        switch (tree.getKind()) {
            case IDENTIFIER: {
                return ASTHelpers.getSymbol(tree).getQualifiedName().toString();
            }
            case MEMBER_SELECT: {
                MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
                Symbol expressionSymbol = ASTHelpers.getSymbol(memberSelectTree.getExpression());
                if (!(expressionSymbol instanceof Symbol.TypeSymbol)) {
                    return ASTHelpers.getSymbol(tree).getQualifiedName().toString();
                }
                return NonCanonicalType.getNonCanonicalName(memberSelectTree.getExpression()) + "." + memberSelectTree.getIdentifier();
            }
            case PARAMETERIZED_TYPE: {
                return NonCanonicalType.getNonCanonicalName(((ParameterizedTypeTree)tree).getType());
            }
        }
        throw new AssertionError((Object)tree.getKind());
    }
}

