/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Types;

@BugPattern(summary="Nested instanceOf conditions of disjoint types create blocks of code that never execute", severity=BugPattern.SeverityLevel.WARNING)
public class NestedInstanceOfConditions
extends BugChecker
implements BugChecker.IfTreeMatcher {
    @Override
    public Description matchIf(IfTree ifTree, VisitorState visitorState) {
        ExpressionTree expressionTree = ASTHelpers.stripParentheses(ifTree.getCondition());
        if (expressionTree instanceof InstanceOfTree) {
            InstanceOfTree instanceOfTree = (InstanceOfTree)expressionTree;
            if (!(instanceOfTree.getExpression() instanceof IdentifierTree)) {
                return Description.NO_MATCH;
            }
            AssignmentTreeMatcher assignmentTreeMatcher = new AssignmentTreeMatcher(instanceOfTree.getExpression());
            Matcher<Tree> containsAssignmentTreeMatcher = Matchers.contains(assignmentTreeMatcher);
            if (containsAssignmentTreeMatcher.matches(ifTree, visitorState)) {
                return Description.NO_MATCH;
            }
            NestedInstanceOfMatcher nestedInstanceOfMatcher = new NestedInstanceOfMatcher(instanceOfTree.getExpression(), instanceOfTree.getType());
            Matcher<Tree> containsNestedInstanceOfMatcher = Matchers.contains(nestedInstanceOfMatcher);
            if (containsNestedInstanceOfMatcher.matches(ifTree.getThenStatement(), visitorState)) {
                return this.describeMatch(ifTree);
            }
        }
        return Description.NO_MATCH;
    }

    private static class NestedInstanceOfMatcher
    implements Matcher<Tree> {
        private final ExpressionTree expressionTree;
        private final Tree typeTree;

        public NestedInstanceOfMatcher(ExpressionTree e, Tree t2) {
            this.expressionTree = e;
            this.typeTree = t2;
        }

        @Override
        public boolean matches(Tree tree, VisitorState state) {
            ExpressionTree conditionTree;
            if (tree instanceof IfTree && (conditionTree = ASTHelpers.stripParentheses(((IfTree)tree).getCondition())) instanceof InstanceOfTree) {
                InstanceOfTree instanceOfTree = (InstanceOfTree)conditionTree;
                Types types = state.getTypes();
                boolean isCastable = types.isCastable(types.erasure(ASTHelpers.getType(instanceOfTree.getType())), types.erasure(ASTHelpers.getType(this.typeTree)));
                boolean isSameExpression = instanceOfTree.getExpression().toString().equals(this.expressionTree.toString());
                return isSameExpression && !isCastable;
            }
            return false;
        }
    }

    private static class AssignmentTreeMatcher
    implements Matcher<Tree> {
        private final ExpressionTree variableExpressionTree;

        public AssignmentTreeMatcher(ExpressionTree e) {
            this.variableExpressionTree = e;
        }

        @Override
        public boolean matches(Tree tree, VisitorState visitorState) {
            if (tree instanceof AssignmentTree) {
                return visitorState.getSourceForNode(this.variableExpressionTree).equals(visitorState.getSourceForNode(((AssignmentTree)tree).getVariable()));
            }
            return false;
        }
    }
}

