/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.OperatorPrecedence;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import javax.annotation.Nullable;

@BugPattern(summary="Compound assignments may hide dangerous casts", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class NarrowingCompoundAssignment
extends BugChecker
implements BugChecker.CompoundAssignmentTreeMatcher {
    static String assignmentToString(Tree.Kind kind) {
        switch (kind) {
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case REMAINDER: {
                return "%";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case LEFT_SHIFT: {
                return "<<";
            }
            case AND: {
                return "&";
            }
            case XOR: {
                return "^";
            }
            case OR: {
                return "|";
            }
            case RIGHT_SHIFT: {
                return ">>";
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return ">>>";
            }
        }
        throw new IllegalArgumentException("Unexpected operator assignment kind: " + kind);
    }

    static Tree.Kind regularAssignmentFromCompound(Tree.Kind kind) {
        switch (kind) {
            case MULTIPLY_ASSIGNMENT: {
                return Tree.Kind.MULTIPLY;
            }
            case DIVIDE_ASSIGNMENT: {
                return Tree.Kind.DIVIDE;
            }
            case REMAINDER_ASSIGNMENT: {
                return Tree.Kind.REMAINDER;
            }
            case PLUS_ASSIGNMENT: {
                return Tree.Kind.PLUS;
            }
            case MINUS_ASSIGNMENT: {
                return Tree.Kind.MINUS;
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.LEFT_SHIFT;
            }
            case AND_ASSIGNMENT: {
                return Tree.Kind.AND;
            }
            case XOR_ASSIGNMENT: {
                return Tree.Kind.XOR;
            }
            case OR_ASSIGNMENT: {
                return Tree.Kind.OR;
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.RIGHT_SHIFT;
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.UNSIGNED_RIGHT_SHIFT;
            }
        }
        throw new IllegalArgumentException("Unexpected compound assignment kind: " + kind);
    }

    @Override
    public Description matchCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        String message = NarrowingCompoundAssignment.identifyBadCast(ASTHelpers.getType(tree.getVariable()), ASTHelpers.getType(tree.getExpression()), state.getTypes());
        if (message == null) {
            return Description.NO_MATCH;
        }
        Optional<Fix> fix = NarrowingCompoundAssignment.rewriteCompoundAssignment(tree, state);
        if (!fix.isPresent()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix(fix.get()).setMessage(message).build();
    }

    @Nullable
    private static String identifyBadCast(Type lhs, Type rhs, Types types) {
        if (!lhs.isPrimitive()) {
            return null;
        }
        if (types.isConvertible(rhs, lhs)) {
            return null;
        }
        return String.format("Compound assignments from %s to %s hide lossy casts", Signatures.prettyType(rhs), Signatures.prettyType(lhs));
    }

    private static Optional<Fix> rewriteCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        OperatorPrecedence rhsPrecedence;
        String var = state.getSourceForNode(tree.getVariable());
        String expr = state.getSourceForNode(tree.getExpression());
        if (var == null || expr == null) {
            return Optional.absent();
        }
        switch (tree.getKind()) {
            case RIGHT_SHIFT_ASSIGNMENT: {
                return Optional.absent();
            }
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: {
                if (!NarrowingCompoundAssignment.twiddlingConstantBitsOk(tree)) break;
                return Optional.absent();
            }
        }
        Tree.Kind regularAssignmentKind = NarrowingCompoundAssignment.regularAssignmentFromCompound(tree.getKind());
        String op = NarrowingCompoundAssignment.assignmentToString(regularAssignmentKind);
        OperatorPrecedence operatorPrecedence = tree.getExpression() instanceof JCTree.JCBinary ? OperatorPrecedence.from(tree.getExpression().getKind()) : (rhsPrecedence = tree.getExpression() instanceof ConditionalExpressionTree ? OperatorPrecedence.TERNARY : null);
        if (rhsPrecedence != null && !rhsPrecedence.isHigher(OperatorPrecedence.from(regularAssignmentKind))) {
            expr = String.format("(%s)", expr);
        }
        String castType = ASTHelpers.getType(tree.getVariable()).toString();
        String replacement = String.format("%s = (%s) (%s %s %s)", var, castType, var, op, expr);
        return Optional.of(SuggestedFix.replace(tree, replacement));
    }

    private static boolean twiddlingConstantBitsOk(CompoundAssignmentTree tree) {
        int shift;
        switch (ASTHelpers.getType(tree.getVariable()).getKind()) {
            case BYTE: {
                shift = 8;
                break;
            }
            case SHORT: {
                shift = 16;
                break;
            }
            default: {
                return false;
            }
        }
        Object constValue = ASTHelpers.constValue(tree.getExpression());
        if (!(constValue instanceof Integer) && !(constValue instanceof Long)) {
            return false;
        }
        long constLong = ((Number)constValue).longValue();
        long shifted = constLong >> shift;
        return shifted == 0L || shifted == -1L;
    }
}

