/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="This calculation may lose precision compared to its target type.", severity=BugPattern.SeverityLevel.WARNING)
public final class NarrowCalculation
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    @Override
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        Type leftType = ASTHelpers.getType(tree.getLeftOperand());
        Type rightType = ASTHelpers.getType(tree.getRightOperand());
        ASTHelpers.TargetType targetType = ASTHelpers.targetType(state);
        if (leftType == null || rightType == null || targetType == null) {
            return Description.NO_MATCH;
        }
        if (tree.getKind().equals((Object)Tree.Kind.DIVIDE) && leftType.isIntegral() && rightType.isIntegral() && NarrowCalculation.isFloatingPoint(targetType.type())) {
            long right;
            long left;
            long divided;
            Object leftConst = ASTHelpers.constValue(tree.getLeftOperand());
            Object rightConst = ASTHelpers.constValue(tree.getRightOperand());
            if (leftConst != null && rightConst != null && (divided = (left = ((Number)leftConst).longValue()) / (right = ((Number)rightConst).longValue())) * right == left) {
                return Description.NO_MATCH;
            }
            return this.buildDescription(tree).setMessage("This division will discard the fractional part of the result, despite being assigned to a float.").addFix(SuggestedFix.builder().setShortDescription("Perform the division using floating point arithmetic").merge(NarrowCalculation.forceExpressionType(tree, targetType.type(), state)).build()).build();
        }
        if (tree.getKind().equals((Object)Tree.Kind.MULTIPLY) && NarrowCalculation.isInt(leftType, state) && NarrowCalculation.isInt(rightType, state) && NarrowCalculation.isLong(targetType.type(), state)) {
            int rightInt;
            int leftInt;
            long product;
            if (state.errorProneOptions().isTestOnlyTarget()) {
                return Description.NO_MATCH;
            }
            Object leftConst = ASTHelpers.constValue(tree.getLeftOperand());
            Object rightConst = ASTHelpers.constValue(tree.getRightOperand());
            if (leftConst != null && rightConst != null && (product = (long)(leftInt = ((Integer)leftConst).intValue()) * (long)(rightInt = ((Integer)rightConst).intValue())) == (long)((int)product)) {
                return Description.NO_MATCH;
            }
            return this.buildDescription(tree).setMessage("This product of integers could overflow before being implicitly cast to a long.").addFix(SuggestedFix.builder().setShortDescription("Perform the multiplication as long * long").merge(NarrowCalculation.forceExpressionType(tree, targetType.type(), state)).build()).build();
        }
        return Description.NO_MATCH;
    }

    private static SuggestedFix forceExpressionType(BinaryTree tree, Type targetType, VisitorState state) {
        if (tree.getRightOperand() instanceof LiteralTree) {
            return SuggestedFix.replace(tree.getRightOperand(), NarrowCalculation.forceLiteralType(tree.getRightOperand(), targetType, state));
        }
        if (tree.getLeftOperand() instanceof LiteralTree) {
            return SuggestedFix.replace(tree.getLeftOperand(), NarrowCalculation.forceLiteralType(tree.getLeftOperand(), targetType, state));
        }
        return SuggestedFix.replace(tree.getRightOperand(), String.format("((%s) %s)", targetType, state.getSourceForNode(tree.getRightOperand())));
    }

    private static String forceLiteralType(ExpressionTree tree, Type targetType, VisitorState state) {
        return state.getSourceForNode(tree).replaceAll("[LlFfDd]$", "") + NarrowCalculation.suffixForType(targetType, state);
    }

    private static String suffixForType(Type type, VisitorState state) {
        Symtab symtab = state.getSymtab();
        if (ASTHelpers.isSameType(type, symtab.longType, state)) {
            return "L";
        }
        if (ASTHelpers.isSameType(type, symtab.floatType, state)) {
            return "f";
        }
        if (ASTHelpers.isSameType(type, symtab.doubleType, state)) {
            return ".0";
        }
        throw new AssertionError();
    }

    private static boolean isFloatingPoint(Type type) {
        return type.isNumeric() && !type.isIntegral();
    }

    private static boolean isInt(Type type, VisitorState state) {
        return ASTHelpers.isSameType(type, state.getSymtab().intType, state);
    }

    private static boolean isLong(Type type, VisitorState state) {
        return ASTHelpers.isSameType(type, state.getSymtab().longType, state);
    }
}

