/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Types;
import java.util.List;

@BugPattern(summary="The first argument to nCopies is the number of copies, and the second is the item to copy", severity=BugPattern.SeverityLevel.ERROR)
public class NCopiesOfChar
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("java.util.Collections").named("nCopies");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        Symtab syms = state.getSymtab();
        Types types = state.getTypes();
        if (types.isSameType(types.unboxedTypeOrType(ASTHelpers.getType(arguments.get(1))), syms.intType) && types.isSameType(types.unboxedTypeOrType(ASTHelpers.getType(arguments.get(0))), syms.charType)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace(arguments.get(0), state.getSourceForNode(arguments.get(1))).replace(arguments.get(1), state.getSourceForNode(arguments.get(0))).build());
        }
        return Description.NO_MATCH;
    }
}

