/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.Objects;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Non-empty arrays are mutable, so this `public static final` array is not a constant and can be modified by clients of this class.  Prefer an ImmutableList, or provide an accessor method that returns a defensive copy.", severity=BugPattern.SeverityLevel.WARNING)
public class MutablePublicArray
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<VariableTree> MATCHER = Matchers.allOf(Matchers.hasModifier(Modifier.PUBLIC), Matchers.hasModifier(Modifier.STATIC), Matchers.hasModifier(Modifier.FINAL), MutablePublicArray::nonEmptyArrayMatcher);

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Tree)tree, "org.junit.experimental.theories.DataPoints", state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static boolean nonEmptyArrayMatcher(VariableTree arrayExpression, VisitorState state) {
        if (!Matchers.isArrayType().matches(arrayExpression, state)) {
            return false;
        }
        ExpressionTree initializer = arrayExpression.getInitializer();
        if (!(initializer instanceof JCTree.JCNewArray)) {
            return false;
        }
        JCTree.JCNewArray newArray = (JCTree.JCNewArray)initializer;
        if (!((List)newArray.getDimensions()).isEmpty()) {
            return !newArray.getDimensions().stream().allMatch(e -> Objects.equals(ASTHelpers.constValue(e, Integer.class), 0));
        }
        return newArray.getInitializers() != null && !((List)newArray.getInitializers()).isEmpty();
    }
}

