/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.ReplacementVariableFinder;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.function.Predicate;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Using a collection function with itself as the argument.", severity=BugPattern.SeverityLevel.ERROR)
public class ModifyingCollectionWithItself
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> IS_COLLECTION_MODIFIED_WITH_ITSELF = ModifyingCollectionWithItself.buildMatcher();

    private static Matcher<MethodInvocationTree> buildMatcher() {
        return Matchers.anyOf(Matchers.allOf(Matchers.anyOf(Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("addAll"), Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("removeAll"), Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("containsAll"), Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("retainAll")), Matchers.receiverSameAsArgument(0)), Matchers.allOf(Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("addAll"), Matchers.receiverSameAsArgument(1)));
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree t2, VisitorState state) {
        if (IS_COLLECTION_MODIFIED_WITH_ITSELF.matches(t2, state)) {
            return this.describe(t2, state);
        }
        return Description.NO_MATCH;
    }

    private Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        ExpressionTree receiver = ASTHelpers.getReceiver(methodInvocationTree);
        List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        ExpressionTree argument = arguments.size() == 2 ? arguments.get(1) : arguments.get(0);
        Description.Builder builder = this.buildDescription(methodInvocationTree);
        for (Fix fix : ModifyingCollectionWithItself.buildFixes(methodInvocationTree, state, receiver, argument)) {
            builder.addFix(fix);
        }
        return builder.build();
    }

    private static List<Fix> buildFixes(MethodInvocationTree methodInvocationTree, VisitorState state, ExpressionTree receiver, ExpressionTree argument) {
        ImmutableList<Fix> fixes;
        if (receiver.getKind() == Tree.Kind.MEMBER_SELECT) {
            fixes = ReplacementVariableFinder.fixesByReplacingExpressionWithMethodParameter(argument, ModifyingCollectionWithItself.isCollectionVariable(state), state);
        } else {
            Preconditions.checkState(receiver.getKind() == Tree.Kind.IDENTIFIER, "receiver.getKind is identifier");
            boolean lhsIsField = ASTHelpers.getSymbol(receiver).getKind() == ElementKind.FIELD;
            ImmutableList<Fix> immutableList = fixes = lhsIsField ? ReplacementVariableFinder.fixesByReplacingExpressionWithMethodParameter(argument, ModifyingCollectionWithItself.isCollectionVariable(state), state) : ReplacementVariableFinder.fixesByReplacingExpressionWithLocallyDeclaredField(receiver, ModifyingCollectionWithItself.isCollectionVariable(state), state);
        }
        if (fixes.isEmpty()) {
            fixes = ModifyingCollectionWithItself.literalReplacement(methodInvocationTree, state, receiver);
        }
        return fixes;
    }

    private static Predicate<JCTree.JCVariableDecl> isCollectionVariable(VisitorState state) {
        return var -> Matchers.variableType(Matchers.isSubtypeOf("java.util.Collection")).matches((VariableTree)var, state);
    }

    private static ImmutableList<Fix> literalReplacement(MethodInvocationTree methodInvocationTree, VisitorState state, ExpressionTree lhs) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof ExpressionStatementTree) {
            SuggestedFix fix = Matchers.instanceMethod().anyClass().named("removeAll").matches(methodInvocationTree, state) ? SuggestedFix.replace(methodInvocationTree, state.getSourceForNode(lhs) + ".clear()") : SuggestedFix.delete(parent);
            return ImmutableList.of(fix);
        }
        return ImmutableList.of();
    }
}

