/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;

@BugPattern(summary="Classes implementing valid compareTo function should implement Comparable interface", severity=BugPattern.SeverityLevel.WARNING)
public class MissingImplementsComparable
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> COMPARABLE_WITHOUT_OVERRIDE = Matchers.allOf(Matchers.compareToMethodDeclaration(), Matchers.not(Matchers.hasAnnotation("java.lang.Override")));
    private static final Matcher<ClassTree> IS_COMPARABLE = Matchers.isSubtypeOf("java.lang.Comparable");

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!COMPARABLE_WITHOUT_OVERRIDE.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ClassTree enclosingClass = ASTHelpers.findEnclosingNode(state.getPath(), ClassTree.class);
        if (enclosingClass == null || IS_COMPARABLE.matches(enclosingClass, state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType(ASTHelpers.getType(Iterables.getOnlyElement(tree.getParameters())), ASTHelpers.getType(enclosingClass), state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

