/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AssertThrowsUtils;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

@BugPattern(altNames={"missing-fail"}, summary="Not calling fail() when expecting an exception masks bugs", severity=BugPattern.SeverityLevel.WARNING)
public class MissingFail
extends BugChecker
implements BugChecker.TryTreeMatcher {
    private static final Matcher<ExpressionTree> ASSERT_EQUALS = Matchers.assertEqualsInvocation();
    private static final Matcher<Tree> ASSERT_UNEQUAL = Matchers.toType(MethodInvocationTree.class, new UnequalIntegerLiteralMatcher(ASSERT_EQUALS));
    private static final Matcher<ExpressionTree> ASSERT_TRUE = Matchers.anyOf(MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertTrue"), MethodMatchers.staticMethod().onClass("junit.framework.Assert").named("assertTrue"), MethodMatchers.staticMethod().onClass("junit.framework.TestCase").named("assertTrue"));
    private static final Matcher<ExpressionTree> ASSERT_FALSE = Matchers.anyOf(MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertFalse"), MethodMatchers.staticMethod().onClass("junit.framework.Assert").named("assertFalse"), MethodMatchers.staticMethod().onClass("junit.framework.TestCase").named("assertFalse"));
    private static final Matcher<ExpressionTree> ASSERT_TRUE_FALSE = Matchers.methodInvocation(ASSERT_TRUE, ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.booleanLiteral(false), Matchers.booleanConstant(false)));
    private static final Matcher<ExpressionTree> ASSERT_FALSE_TRUE = Matchers.methodInvocation(ASSERT_FALSE, ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.booleanLiteral(true), Matchers.booleanConstant(true)));
    private static final Matcher<ExpressionTree> ASSERT_TRUE_TRUE = Matchers.methodInvocation(ASSERT_TRUE, ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.booleanLiteral(true), Matchers.booleanConstant(true)));
    private static final Matcher<ExpressionTree> ASSERT_FALSE_FALSE = Matchers.methodInvocation(ASSERT_FALSE, ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.booleanLiteral(false), Matchers.booleanConstant(false)));
    private static final Matcher<StatementTree> JAVA_ASSERT_FALSE = Matchers.assertStatement(Matchers.ignoreParens(Matchers.anyOf(Matchers.booleanLiteral(false), Matchers.booleanConstant(false))));
    private static final Matcher<ExpressionTree> LOG_CALL = Matchers.anyOf(MethodMatchers.instanceMethod().onClass((t2, s2) -> ((Name)t2.asElement().getSimpleName()).toString().contains("Logger")).withAnyName(), MethodMatchers.instanceMethod().anyClass().withNameMatching(Pattern.compile("log.*")));
    private static final Matcher<Tree> LOG_IN_BLOCK = Matchers.contains(Matchers.toType(ExpressionTree.class, LOG_CALL));
    private static final Pattern FAIL_PATTERN = Pattern.compile(".*(?i:fail).*");
    private static final Matcher<ExpressionTree> FAIL = MethodMatchers.anyMethod().anyClass().withNameMatching(FAIL_PATTERN);
    private static final Matcher<ExpressionTree> ASSERT_CALL = Matchers.methodInvocation(new AssertMethodMatcher());
    private static final Matcher<ExpressionTree> REAL_ASSERT_CALL = Matchers.allOf(ASSERT_CALL, Matchers.not(Matchers.anyOf(ASSERT_FALSE_FALSE, ASSERT_TRUE_TRUE)));
    private static final Matcher<ExpressionTree> VERIFY_CALL = MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("verify");
    private static final MultiMatcher<TryTree, Tree> ASSERT_LAST_CALL_IN_TRY = new ChildOfTryMatcher(ChildMultiMatcher.MatchType.LAST, Matchers.contains(Matchers.toType(ExpressionTree.class, Matchers.anyOf(REAL_ASSERT_CALL, VERIFY_CALL))));
    private static final Matcher<Tree> ASSERT_IN_BLOCK = Matchers.contains(Matchers.toType(ExpressionTree.class, REAL_ASSERT_CALL));
    private static final Matcher<StatementTree> THROW_STATEMENT = Matchers.throwStatement(Matchers.anything());
    private static final Matcher<Tree> THROW_OR_FAIL_IN_BLOCK = Matchers.contains(Matchers.anyOf(Matchers.toType(StatementTree.class, THROW_STATEMENT), Matchers.toType(ExpressionTree.class, ASSERT_TRUE_FALSE), Matchers.toType(ExpressionTree.class, ASSERT_FALSE_TRUE), Matchers.toType(ExpressionTree.class, ASSERT_UNEQUAL), Matchers.toType(StatementTree.class, JAVA_ASSERT_FALSE), Matchers.toType(ExpressionTree.class, FAIL)));
    private static final Matcher<TryTree> NON_TEST_METHOD = new IgnoredEnclosingMethodMatcher();
    private static final Matcher<Tree> RETURN_IN_BLOCK = Matchers.contains(Matchers.toType(StatementTree.class, Matchers.returnStatement(Matchers.anything())));
    private static final Matcher<StatementTree> RETURN_AFTER = Matchers.nextStatement(Matchers.returnStatement(Matchers.anything()));
    private static final Matcher<VariableTree> INAPPLICABLE_EXCEPTION = Matchers.anyOf(Matchers.isSameType("java.lang.InterruptedException"), Matchers.isSameType("java.lang.AssertionError"), Matchers.isSameType("java.lang.Throwable"), Matchers.isSameType("junit.framework.AssertionFailedError"));
    private static final InLoopMatcher IN_LOOP = new InLoopMatcher();
    private static final Matcher<Tree> WHILE_TRUE_IN_BLOCK = Matchers.contains(Matchers.toType(WhileLoopTree.class, new WhileTrueLoopMatcher()));
    private static final Matcher<Tree> CONTINUE_IN_BLOCK = Matchers.contains(Matchers.toType(StatementTree.class, Matchers.continueStatement()));
    private static final Matcher<AssignmentTree> FIELD_ASSIGNMENT = Matchers.assignment(Matchers.isInstanceField(), Matchers.anything());
    private static final Matcher<Tree> FIELD_ASSIGNMENT_IN_BLOCK = Matchers.contains(Matchers.toType(AssignmentTree.class, FIELD_ASSIGNMENT));
    private static final Matcher<ExpressionTree> BOOLEAN_ASSERT_VAR = Matchers.methodInvocation(Matchers.anyOf(ASSERT_FALSE, ASSERT_TRUE), ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.isInstanceField(), Matchers.isVariable()));
    private static final Matcher<Tree> BOOLEAN_ASSERT_VAR_IN_BLOCK = Matchers.contains(Matchers.toType(ExpressionTree.class, BOOLEAN_ASSERT_VAR));
    private static final Matcher<ClassTree> TEST_CLASS = Matchers.anyOf(JUnitMatchers.isTestCaseDescendant, JUnitMatchers.hasJUnit4TestRunner, JUnitMatchers.hasJUnit4TestCases);

    @Override
    public Description matchTry(TryTree tree, VisitorState state) {
        if (MissingFail.tryTreeMatches(tree, state)) {
            List<? extends StatementTree> tryStatements = tree.getBlock().getStatements();
            StatementTree lastTryStatement = tryStatements.get(tryStatements.size() - 1);
            Optional<Fix> assertThrowsFix = AssertThrowsUtils.tryFailToAssertThrows(tree, tryStatements, Optional.empty(), state);
            Fix failFix = MissingFail.addFailCall(tree, lastTryStatement, state);
            return this.buildDescription(lastTryStatement).addFix(assertThrowsFix.orElse(SuggestedFix.emptyFix())).addFix(failFix).build();
        }
        return Description.NO_MATCH;
    }

    public static Fix addFailCall(TryTree tree, StatementTree lastTryStatement, VisitorState state) {
        String failCall = String.format("\nfail(\"Expected %s\");", MissingFail.exceptionToString(tree, state));
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder().postfixWith(lastTryStatement, failCall);
        fixBuilder.removeStaticImport("junit.framework.Assert.fail");
        fixBuilder.removeStaticImport("junit.framework.TestCase.fail");
        fixBuilder.addStaticImport("org.junit.Assert.fail");
        return fixBuilder.build();
    }

    private static String exceptionToString(TryTree tree, VisitorState state) {
        if (tree.getCatches().size() != 1) {
            return "Exception";
        }
        Tree exceptionType = tree.getCatches().iterator().next().getParameter().getType();
        Type type = ASTHelpers.getType(exceptionType);
        if (type != null && type.isUnion()) {
            return "Exception";
        }
        return state.getSourceForNode(exceptionType);
    }

    private static boolean tryTreeMatches(TryTree tree, VisitorState state) {
        if (!MissingFail.isInClass(tree, state, TEST_CLASS)) {
            return false;
        }
        if (MissingFail.hasToleratedException(tree)) {
            return false;
        }
        boolean assertInCatch = MissingFail.hasAssertInCatch(tree, state);
        if (!MissingFail.hasExpectedException(tree) && !assertInCatch) {
            return false;
        }
        if (MissingFail.hasThrowOrFail(tree, state) || MissingFail.isInInapplicableMethod(tree, state) || MissingFail.returnsInTryCatchOrAfter(tree, state) || MissingFail.isInapplicableExceptionType(tree, state) || MissingFail.isInLoop(state, tree) || MissingFail.hasWhileTrue(tree, state) || MissingFail.hasContinue(tree, state) || MissingFail.hasFinally(tree) || MissingFail.logsInCatch(state, tree)) {
            return false;
        }
        if (assertInCatch && (MissingFail.hasFieldAssignmentInCatch(tree, state) || MissingFail.hasBooleanAssertVariableInCatch(tree, state) || MissingFail.lastTryStatementIsAssert(tree, state))) {
            return false;
        }
        return !tree.getBlock().getStatements().isEmpty();
    }

    private static boolean hasWhileTrue(TryTree tree, VisitorState state) {
        return WHILE_TRUE_IN_BLOCK.matches(tree, state);
    }

    private static boolean isInClass(TryTree tree, VisitorState state, Matcher<ClassTree> classTree) {
        return Matchers.enclosingNode(Matchers.toType(ClassTree.class, classTree)).matches(tree, state);
    }

    private static boolean hasBooleanAssertVariableInCatch(TryTree tree, VisitorState state) {
        return MissingFail.anyCatchBlockMatches(tree, state, BOOLEAN_ASSERT_VAR_IN_BLOCK);
    }

    private static boolean lastTryStatementIsAssert(TryTree tree, VisitorState state) {
        return ASSERT_LAST_CALL_IN_TRY.matches(tree, state);
    }

    private static boolean hasFieldAssignmentInCatch(TryTree tree, VisitorState state) {
        return MissingFail.anyCatchBlockMatches(tree, state, FIELD_ASSIGNMENT_IN_BLOCK);
    }

    private static boolean logsInCatch(VisitorState state, TryTree tree) {
        return MissingFail.anyCatchBlockMatches(tree, state, LOG_IN_BLOCK);
    }

    private static boolean hasFinally(TryTree tree) {
        return tree.getFinallyBlock() != null;
    }

    private static boolean hasContinue(TryTree tree, VisitorState state) {
        return CONTINUE_IN_BLOCK.matches(tree, state);
    }

    private static boolean isInLoop(VisitorState state, TryTree tree) {
        return IN_LOOP.matches(tree, state);
    }

    private static boolean isInapplicableExceptionType(TryTree tree, VisitorState state) {
        for (CatchTree catchTree : tree.getCatches()) {
            if (!INAPPLICABLE_EXCEPTION.matches(catchTree.getParameter(), state)) continue;
            return true;
        }
        return false;
    }

    private static boolean returnsInTryCatchOrAfter(TryTree tree, VisitorState state) {
        return RETURN_IN_BLOCK.matches(tree, state) || RETURN_AFTER.matches(tree, state);
    }

    private static boolean isInInapplicableMethod(TryTree tree, VisitorState state) {
        return NON_TEST_METHOD.matches(tree, state);
    }

    private static boolean hasThrowOrFail(TryTree tree, VisitorState state) {
        return THROW_OR_FAIL_IN_BLOCK.matches(tree, state);
    }

    private static boolean hasAssertInCatch(TryTree tree, VisitorState state) {
        return MissingFail.anyCatchBlockMatches(tree, state, ASSERT_IN_BLOCK);
    }

    private static boolean hasToleratedException(TryTree tree) {
        for (CatchTree catchTree : tree.getCatches()) {
            if (!catchTree.getParameter().getName().contentEquals("tolerated")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExpectedException(TryTree tree) {
        for (CatchTree catchTree : tree.getCatches()) {
            if (!catchTree.getParameter().getName().contentEquals("expected")) continue;
            return true;
        }
        return false;
    }

    private static boolean anyCatchBlockMatches(TryTree tree, VisitorState state, Matcher<Tree> matcher) {
        for (CatchTree catchTree : tree.getCatches()) {
            if (!matcher.matches(catchTree.getBlock(), state)) continue;
            return true;
        }
        return false;
    }

    private static class ChildOfTryMatcher
    extends ChildMultiMatcher<TryTree, Tree> {
        public ChildOfTryMatcher(ChildMultiMatcher.MatchType matchType, Matcher<Tree> nodeMatcher) {
            super(matchType, nodeMatcher);
        }

        @Override
        protected Iterable<? extends StatementTree> getChildNodes(TryTree tree, VisitorState state) {
            return tree.getBlock().getStatements();
        }
    }

    private static class UnequalIntegerLiteralMatcher
    implements Matcher<MethodInvocationTree> {
        private final Matcher<ExpressionTree> methodSelectMatcher;

        private UnequalIntegerLiteralMatcher(Matcher<ExpressionTree> methodSelectMatcher) {
            this.methodSelectMatcher = methodSelectMatcher;
        }

        @Override
        public boolean matches(MethodInvocationTree methodInvocationTree, VisitorState state) {
            return this.methodSelectMatcher.matches(methodInvocationTree, state) && UnequalIntegerLiteralMatcher.matches(methodInvocationTree.getArguments());
        }

        private static boolean matches(List<? extends ExpressionTree> expressionTrees) {
            HashSet<Integer> foundValues = new HashSet<Integer>();
            for (Tree tree : expressionTrees) {
                boolean duplicate;
                Object value;
                if (!(tree instanceof LiteralTree) || !((value = ((LiteralTree)tree).getValue()) instanceof Integer) || (duplicate = !foundValues.add((Integer)value)) || foundValues.size() <= 1) continue;
                return true;
            }
            return false;
        }
    }

    private static class IgnoredEnclosingMethodMatcher
    implements Matcher<TryTree> {
        private IgnoredEnclosingMethodMatcher() {
        }

        @Override
        public boolean matches(TryTree tryTree, VisitorState state) {
            MethodTree enclosingMethodTree = ASTHelpers.findEnclosingNode(state.getPath(), MethodTree.class);
            if (enclosingMethodTree == null) {
                return true;
            }
            javax.lang.model.element.Name name = enclosingMethodTree.getName();
            return JUnitMatchers.looksLikeJUnit3SetUp.matches(enclosingMethodTree, state) || JUnitMatchers.looksLikeJUnit3TearDown.matches(enclosingMethodTree, state) || name.contentEquals("main") || name.contentEquals("suite") || Matchers.hasAnnotation("org.junit.Before").matches(enclosingMethodTree, state) || Matchers.hasAnnotation("org.junit.After").matches(enclosingMethodTree, state);
        }
    }

    private static class WhileTrueLoopMatcher
    implements Matcher<WhileLoopTree> {
        private WhileTrueLoopMatcher() {
        }

        @Override
        public boolean matches(WhileLoopTree tree, VisitorState state) {
            return Matchers.ignoreParens(Matchers.booleanLiteral(true)).matches(tree.getCondition(), state);
        }
    }

    private static class InLoopMatcher
    implements Matcher<TryTree> {
        private InLoopMatcher() {
        }

        @Override
        public boolean matches(TryTree tryTree, VisitorState state) {
            return ASTHelpers.findEnclosingNode(state.getPath(), DoWhileLoopTree.class) != null || ASTHelpers.findEnclosingNode(state.getPath(), EnhancedForLoopTree.class) != null || ASTHelpers.findEnclosingNode(state.getPath(), WhileLoopTree.class) != null || ASTHelpers.findEnclosingNode(state.getPath(), ForLoopTree.class) != null;
        }
    }

    private static class AssertMethodMatcher
    implements Matcher<ExpressionTree> {
        private AssertMethodMatcher() {
        }

        @Override
        public boolean matches(ExpressionTree expressionTree, VisitorState state) {
            Symbol sym = ASTHelpers.getSymbol(expressionTree);
            if (sym == null) {
                return false;
            }
            String symSimpleName = sym.getSimpleName().toString();
            return symSimpleName.startsWith("assert") || symSimpleName.startsWith("verify");
        }
    }
}

