/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@BugPattern(summary="Anytime you need to look up a constant value from VisitorState, improve performance by creating a cache for it with VisitorState.memoize", severity=BugPattern.SeverityLevel.WARNING)
public class MemoizeConstantVisitorStateLookups
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> CONSTANT_LOOKUP = Matchers.instanceMethod().onExactClass(VisitorState.class.getName()).namedAnyOf("getName", "getTypeFromString", "getSymbolFromString").withParameters(String.class.getName(), new String[0]);
    private static final Matcher<ExpressionTree> MEMOIZE_CALL = Matchers.staticMethod().onClass(VisitorState.class.getName()).named("memoize");

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        tree.getTypeDecls().stream().filter(t2 -> t2 instanceof ClassTree).forEach(t2 -> state.reportMatch(this.fixLookupsInClass((ClassTree)t2, state)));
        return Description.NO_MATCH;
    }

    private Description fixLookupsInClass(ClassTree tree, VisitorState state) {
        ImmutableList<CallSite> lookups = this.findConstantLookups(tree, state);
        if (lookups.isEmpty()) {
            return Description.NO_MATCH;
        }
        Map<String, Map<Name, List<CallSite>>> groupedCallSites = lookups.stream().collect(Collectors.groupingBy(callSite -> callSite.argumentValue, Collectors.groupingBy(callSite -> callSite.method)));
        SuggestedFix.Builder fix = SuggestedFix.builder();
        ImmutableSortedSet.Builder membersToAdd = new ImmutableSortedSet.Builder(Comparator.naturalOrder());
        for (Map.Entry<String, Map<Name, List<CallSite>>> lookup : groupedCallSites.entrySet()) {
            String argument = lookup.getKey();
            Map<Name, List<CallSite>> usages = lookup.getValue();
            if (usages.size() == 1) {
                Map.Entry<Name, List<CallSite>> useSites = usages.entrySet().iterator().next();
                Name methodName = useSites.getKey();
                List<CallSite> instances = useSites.getValue();
                MemoizeConstantVisitorStateLookups.memoizeSupplier(state, fix, membersToAdd::add, argument, methodName, instances, (name, type) -> name);
                continue;
            }
            for (Map.Entry<Name, List<CallSite>> usage : usages.entrySet()) {
                Name methodName = usage.getKey();
                List<CallSite> instances = usage.getValue();
                MemoizeConstantVisitorStateLookups.memoizeSupplier(state, fix, membersToAdd::add, argument, methodName, instances, (name, type) -> name + "_" + type);
            }
        }
        SuggestedFixes.addMembers(tree, state, SuggestedFixes.AdditionPosition.LAST, membersToAdd.build()).ifPresent(fix::merge);
        MethodInvocationTree fixTree = lookups.stream().map(cs -> cs.entireTree).min(Comparator.comparingInt(ASTHelpers::getStartPosition)).get();
        return this.describeMatch(fixTree, (Fix)fix.build());
    }

    private ImmutableList<CallSite> findConstantLookups(ClassTree tree, VisitorState state) {
        final ImmutableList.Builder result = ImmutableList.builder();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (CONSTANT_LOOKUP.matches(tree, this.state)) {
                    this.handleConstantLookup(tree);
                } else if (MEMOIZE_CALL.matches(tree, this.state)) {
                    return null;
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }

            private void handleConstantLookup(MethodInvocationTree tree) {
                ExpressionTree methodSelect;
                ExpressionTree argumentExpr = tree.getArguments().get(0);
                String argumentValue = ASTHelpers.constValue(argumentExpr, String.class);
                if (argumentValue != null && (methodSelect = tree.getMethodSelect()) instanceof JCTree.JCFieldAccess) {
                    JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)methodSelect;
                    Name method = fieldAccess.name;
                    result.add(new CallSite(method, argumentValue, argumentExpr, tree));
                }
            }
        }.scan(state.getPath(), null);
        return result.build();
    }

    private static void memoizeSupplier(VisitorState state, SuggestedFix.Builder fix, Consumer<String> memberConsumer, String argument, Name methodName, List<CallSite> instances, BiFunction<String, String, String> namingStrategy) {
        CallSite prototype = MemoizeConstantVisitorStateLookups.bestCallsite(instances);
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(prototype.entireTree);
        Symbol.TypeSymbol returnType = sym.getReturnType().tsym;
        String returnTypeName = ((Name)returnType.getSimpleName()).toString();
        String newConstantPrefix = Ascii.toUpperCase(argument).replaceAll("\\W", "_");
        String newConstantName = namingStrategy.apply(newConstantPrefix, Ascii.toUpperCase(returnTypeName));
        memberConsumer.accept(String.format("private static final %s<%s> %s = %s.memoize(state -> state.%s(%s));", SuggestedFixes.qualifyType(state, fix, Supplier.class.getCanonicalName()), SuggestedFixes.qualifyType(state, fix, returnType.getQualifiedName().toString()), newConstantName, SuggestedFixes.qualifyType(state, fix, VisitorState.class.getCanonicalName()), methodName, state.getSourceForNode(prototype.argumentExpression)));
        for (CallSite instance : instances) {
            ExpressionTree visitorStateExpr = ASTHelpers.getReceiver(instance.entireTree);
            fix.replace(instance.entireTree, String.format("%s.get(%s)", newConstantName, state.getSourceForNode(visitorStateExpr)));
        }
    }

    private static CallSite bestCallsite(List<CallSite> instances) {
        return instances.stream().max(Comparator.comparingInt(callsite -> callsite.argumentExpression.getKind() == Tree.Kind.STRING_LITERAL ? 0 : 1)).orElseThrow(() -> new IllegalArgumentException("No callsites"));
    }

    private static final class CallSite {
        final Name method;
        final String argumentValue;
        final ExpressionTree argumentExpression;
        final MethodInvocationTree entireTree;

        CallSite(Name method, String argumentValue, ExpressionTree argumentExpression, MethodInvocationTree entireTree) {
            this.method = method;
            this.argumentValue = argumentValue;
            this.argumentExpression = argumentExpression;
            this.entireTree = entireTree;
        }
    }
}

