/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="Methods and non-static variables should be named in lowerCamelCase.", linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s5.2-specific-identifier-names")
public final class MemberName
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Supplier<ImmutableSet<Name>> EXEMPTED_CLASS_ANNOTATIONS = VisitorState.memoize(s2 -> Stream.of("org.robolectric.annotation.Implements").map(s2::getName).collect(ImmutableSet.toImmutableSet()));
    private static final Supplier<ImmutableSet<Name>> EXEMPTED_METHOD_ANNOTATIONS = VisitorState.memoize(s2 -> Stream.of("com.pholser.junit.quickcheck.Property", "com.google.caliper.Benchmark", "com.google.caliper.api.Macrobenchmark", "com.google.caliper.api.Footprint").map(s2::getName).collect(ImmutableSet.toImmutableSet()));
    private static final String STATIC_VARIABLE_FINDING = "Static variables should be named in UPPER_SNAKE_CASE if deeply immutable or lowerCamelCase if not.";
    private static final ImmutableSet<ElementKind> LOCAL_VARIABLE_KINDS = ImmutableSet.of(ElementKind.LOCAL_VARIABLE, ElementKind.RESOURCE_VARIABLE, ElementKind.EXCEPTION_PARAMETER);
    private static final Pattern LOWER_UNDERSCORE_PATTERN = Pattern.compile("[a-z0-9_]+");
    private static final Pattern UPPER_UNDERSCORE_PATTERN = Pattern.compile("[A-Z0-9_]+");
    private static final Splitter UNDERSCORE_SPLITTER = Splitter.on('_');

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        if (!ASTHelpers.annotationsAmong(symbol.owner, (Set<? extends Name>)EXEMPTED_CLASS_ANNOTATIONS.get(state), state).isEmpty()) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.annotationsAmong(symbol, (Set<? extends Name>)EXEMPTED_METHOD_ANNOTATIONS.get(state), state).isEmpty()) {
            return Description.NO_MATCH;
        }
        if (MemberName.hasTestAnnotation(symbol)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)symbol, "org.junit.Ignore", state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.findSuperMethods(symbol, state.getTypes()).isEmpty()) {
            return Description.NO_MATCH;
        }
        if (tree.getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
            return Description.NO_MATCH;
        }
        if (((Name)symbol.getSimpleName()).toString().startsWith("parametersFor")) {
            return Description.NO_MATCH;
        }
        if (JUnitMatchers.TEST_CASE.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        String name = tree.getName().toString();
        if (MemberName.isConformant(symbol, name)) {
            return Description.NO_MATCH;
        }
        String suggested = MemberName.suggestedRename(symbol, name);
        return suggested.equals(name) || !ASTHelpers.canBeRemoved(symbol, state) ? this.buildDescription(tree).setMessage(String.format("Methods and non-static variables should be named in lowerCamelCase; did you mean '%s'?", suggested)).build() : this.describeMatch(tree, (Fix)SuggestedFixes.renameMethodWithInvocations(tree, suggested, state));
    }

    private static boolean hasTestAnnotation(Symbol.MethodSymbol symbol) {
        return symbol.getRawAttributes().stream().anyMatch(c -> ((Name)c.type.tsym.getSimpleName()).toString().contains("Test"));
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol(tree);
        String name = tree.getName().toString();
        if (UPPER_UNDERSCORE_PATTERN.matcher(name).matches() && !symbol.isStatic()) {
            return Description.NO_MATCH;
        }
        if (MemberName.isConformant(symbol, name)) {
            return Description.NO_MATCH;
        }
        String suggested = MemberName.suggestedRename(symbol, name);
        return this.buildDescription(tree).addFix(suggested.equals(name) || !MemberName.canBeRenamed(symbol) ? SuggestedFix.emptyFix() : SuggestedFixes.renameVariable(tree, suggested, state)).setMessage(MemberName.isStaticVariable(symbol) ? STATIC_VARIABLE_FINDING : this.message()).build();
    }

    private static String suggestedRename(Symbol symbol, String name) {
        if (!MemberName.isStaticVariable(symbol) && UPPER_UNDERSCORE_PATTERN.matcher(name).matches()) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        }
        if (LOWER_UNDERSCORE_PATTERN.matcher(name).matches()) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        }
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, UNDERSCORE_SPLITTER.splitToStream(name).map(c -> CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, (String)c)).collect(Collectors.joining("")));
    }

    private static boolean canBeRenamed(Symbol symbol) {
        return symbol.isPrivate() || LOCAL_VARIABLE_KINDS.contains((Object)symbol.getKind());
    }

    private static boolean isConformant(Symbol symbol, String name) {
        if (MemberName.isStaticVariable(symbol) && UPPER_UNDERSCORE_PATTERN.matcher(name).matches()) {
            return true;
        }
        return !name.contains("_") && !Ascii.isUpperCase(name.charAt(0));
    }

    private static boolean isStaticVariable(Symbol symbol) {
        return symbol instanceof Symbol.VarSymbol && ASTHelpers.isStatic(symbol);
    }
}

