/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Math.abs does not always give a positive result. Please consider other methods for positive numbers.", severity=BugPattern.SeverityLevel.WARNING, altNames={"MathAbsoluteRandom"})
public final class MathAbsoluteNegative
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> POSSIBLY_NEGATIVE_ABS_VAL = Matchers.allOf(Matchers.staticMethod().onClass("java.lang.Math").named("abs"), Matchers.argument(0, Matchers.anyOf(Matchers.instanceMethod().onDescendantOf("java.util.Random").namedAnyOf("nextInt", "nextLong").withNoParameters(), Matchers.instanceMethod().onDescendantOf("java.util.UUID").namedAnyOf("getLeastSignificantBits", "getMostSignificantBits").withNoParameters(), Matchers.instanceMethod().onDescendantOf("java.lang.Object").named("hashCode").withNoParameters(), Matchers.staticMethod().onClass("java.lang.System").named("identityHashCode"), Matchers.instanceMethod().onDescendantOf("com.google.common.hash.HashCode").namedAnyOf("asInt", "asLong", "padToLong").withNoParameters())));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (POSSIBLY_NEGATIVE_ABS_VAL.matches(tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

