/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.function.Predicate;

@BugPattern(summary="Using an unnecessarily-wide comparison method can lead to lossy comparison", explanation="Implicit widening conversions when comparing two primitives with methods like Float.compare can lead to lossy comparison. For example, `Float.compare(Integer.MAX_VALUE, Integer.MAX_VALUE - 1) == 0`. Use a compare method with non-lossy conversion, or ideally no conversion if possible.", severity=BugPattern.SeverityLevel.ERROR)
public class LossyPrimitiveCompare
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> COMPARE_MATCHER = MethodMatchers.staticMethod().onClassAny("java.lang.Float", "java.lang.Double").named("compare");
    private static final Matcher<ExpressionTree> FLOAT_COMPARE_MATCHER = MethodMatchers.staticMethod().onClass("java.lang.Float").named("compare");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!COMPARE_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Types types = state.getTypes();
        Symtab symtab = state.getSymtab();
        ImmutableList argTypes = tree.getArguments().stream().map(ASTHelpers::getType).collect(ImmutableList.toImmutableList());
        Predicate<Type> argsAreConvertible = type -> argTypes.stream().allMatch(t2 -> types.isConvertible((Type)t2, (Type)type));
        if (!(argsAreConvertible.test(symtab.byteType) || argsAreConvertible.test(symtab.charType) || argsAreConvertible.test(symtab.shortType))) {
            if (argsAreConvertible.test(symtab.intType)) {
                if (FLOAT_COMPARE_MATCHER.matches(tree, state)) {
                    return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree.getMethodSelect(), "Integer.compare"));
                }
            } else if (argsAreConvertible.test(symtab.longType)) {
                return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree.getMethodSelect(), "Long.compare"));
            }
        }
        return Description.NO_MATCH;
    }
}

