/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="Loop condition is never modified in loop body.", severity=BugPattern.SeverityLevel.ERROR)
public class LoopConditionChecker
extends BugChecker
implements BugChecker.ForLoopTreeMatcher,
BugChecker.DoWhileLoopTreeMatcher,
BugChecker.WhileLoopTreeMatcher {
    @Override
    public Description matchDoWhileLoop(DoWhileLoopTree tree, VisitorState state) {
        return this.check(tree.getCondition(), ImmutableList.of(tree.getCondition(), tree.getStatement()));
    }

    @Override
    public Description matchForLoop(ForLoopTree tree, VisitorState state) {
        if (tree.getCondition() == null) {
            return Description.NO_MATCH;
        }
        return this.check(tree.getCondition(), (ImmutableList<Tree>)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(tree.getCondition())).add(tree.getStatement())).addAll(tree.getUpdate())).build());
    }

    @Override
    public Description matchWhileLoop(WhileLoopTree tree, VisitorState state) {
        return this.check(tree.getCondition(), ImmutableList.of(tree.getCondition(), tree.getStatement()));
    }

    private Description check(ExpressionTree condition, ImmutableList<Tree> loopBodyTrees) {
        ImmutableSet<Symbol.VarSymbol> conditionVars = LoopConditionVisitor.scan(condition);
        if (conditionVars.isEmpty()) {
            return Description.NO_MATCH;
        }
        for (Tree tree : loopBodyTrees) {
            if (!UpdateScanner.scan(tree, conditionVars)) continue;
            return Description.NO_MATCH;
        }
        return this.buildDescription(condition).setMessage(String.format("condition variable(s) never modified in loop body: %s", Joiner.on(", ").join(conditionVars))).build();
    }

    private static class UpdateScanner
    extends TreeScanner<Void, Void> {
        private boolean modified = false;
        private final ImmutableSet<Symbol.VarSymbol> variables;

        public static boolean scan(Tree tree, ImmutableSet<Symbol.VarSymbol> variables) {
            UpdateScanner scanner = new UpdateScanner(variables);
            tree.accept(scanner, null);
            return scanner.modified;
        }

        public UpdateScanner(ImmutableSet<Symbol.VarSymbol> variables) {
            this.variables = variables;
        }

        @Override
        public Void visitUnary(UnaryTree tree, Void unused) {
            switch (tree.getKind()) {
                case POSTFIX_INCREMENT: 
                case PREFIX_INCREMENT: 
                case POSTFIX_DECREMENT: 
                case PREFIX_DECREMENT: {
                    this.check(tree.getExpression());
                    break;
                }
            }
            return (Void)super.visitUnary(tree, unused);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
            this.check(ASTHelpers.getReceiver(tree));
            return (Void)super.visitMethodInvocation(tree, unused);
        }

        @Override
        public Void visitAssignment(AssignmentTree tree, Void unused) {
            this.check(tree.getVariable());
            return (Void)super.visitAssignment(tree, unused);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree tree, Void unused) {
            this.check(tree.getVariable());
            return (Void)super.visitCompoundAssignment(tree, unused);
        }

        private void check(ExpressionTree expression) {
            Symbol sym = ASTHelpers.getSymbol(expression);
            this.modified |= this.variables.contains(sym);
        }
    }

    private static class LoopConditionVisitor
    extends SimpleTreeVisitor<Boolean, Void> {
        private final ImmutableSet.Builder<Symbol.VarSymbol> conditionVars;

        static ImmutableSet<Symbol.VarSymbol> scan(Tree tree) {
            ImmutableSet.Builder<Symbol.VarSymbol> conditionVars = ImmutableSet.builder();
            if (!MoreObjects.firstNonNull(tree.accept(new LoopConditionVisitor(conditionVars), null), false).booleanValue()) {
                return ImmutableSet.of();
            }
            return conditionVars.build();
        }

        public LoopConditionVisitor(ImmutableSet.Builder<Symbol.VarSymbol> conditionVars) {
            this.conditionVars = conditionVars;
        }

        @Override
        public Boolean visitIdentifier(IdentifierTree tree, Void unused) {
            Symbol sym = ASTHelpers.getSymbol(tree);
            if (sym instanceof Symbol.VarSymbol) {
                switch (sym.getKind()) {
                    case LOCAL_VARIABLE: 
                    case PARAMETER: {
                        this.conditionVars.add((Object)((Symbol.VarSymbol)sym));
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public Boolean visitLiteral(LiteralTree tree, Void unused) {
            return true;
        }

        @Override
        public Boolean visitUnary(UnaryTree node, Void unused) {
            return node.getExpression().accept(this, null);
        }

        @Override
        public Boolean visitBinary(BinaryTree node, Void unused) {
            return MoreObjects.firstNonNull(node.getLeftOperand().accept(this, null), false) != false && MoreObjects.firstNonNull(node.getRightOperand().accept(this, null), false) != false;
        }
    }
}

