/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="This pattern will silently corrupt certain byte sequences from the serialized protocol message. Use ByteString or byte[] directly", severity=BugPattern.SeverityLevel.ERROR)
public class LiteByteStringUtf8
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> BYTE_STRING_UTF_8 = Matchers.allOf(Matchers.instanceMethod().onDescendantOf("com.google.protobuf.ByteString").named("toStringUtf8"), Matchers.receiverOfInvocation(Matchers.toType(MethodInvocationTree.class, Matchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite").named("toByteString"))));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return BYTE_STRING_UTF_8.matches(tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

