/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_LenientFormatStringValidation_LenientFormatMethod;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@BugPattern(severity=BugPattern.SeverityLevel.ERROR, summary="The number of arguments provided to lenient format methods should match the positional specifiers.")
public final class LenientFormatStringValidation
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableList<LenientFormatMethod> METHODS = ImmutableList.of(LenientFormatMethod.create(Matchers.staticMethod().onClass("com.google.common.base.Preconditions").withNameMatching(Pattern.compile("^check.*")), 1), LenientFormatMethod.create(Matchers.staticMethod().onClass("com.google.common.base.Verify").withNameMatching(Pattern.compile("^verify.*")), 1), LenientFormatMethod.create(Matchers.staticMethod().onClass("com.google.common.base.Strings").named("lenientFormat"), 0), LenientFormatMethod.create(Matchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertWithMessage"), 0), LenientFormatMethod.create(Matchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").named("check"), 0), LenientFormatMethod.create(Matchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("withMessage"), 0));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        for (LenientFormatMethod method : METHODS) {
            int actual;
            int expected;
            ExpressionTree formatStringArgument;
            Object formatString;
            List<? extends ExpressionTree> args;
            if (!method.matcher().matches(tree, state) || (args = tree.getArguments()).size() <= method.formatStringPosition() || !((formatString = ASTHelpers.constValue(formatStringArgument = args.get(method.formatStringPosition()))) instanceof String) || (expected = LenientFormatStringValidation.occurrences((String)formatString, "%s")) == (actual = args.size() - method.formatStringPosition() - 1)) continue;
            Description.Builder builder = this.buildDescription(tree).setMessage(String.format("Expected %s positional arguments, but saw %s", expected, actual));
            if (expected < actual) {
                String extraArgs = Collections.nCopies(actual - expected, "%s").stream().collect(Collectors.joining(", ", " (", ")"));
                int endPos = state.getEndPosition(formatStringArgument);
                builder.addFix(formatStringArgument instanceof LiteralTree ? SuggestedFix.replace(endPos - 1, endPos, extraArgs + "\"") : SuggestedFix.postfixWith(formatStringArgument, String.format("+ \"%s\"", extraArgs)));
            }
            return builder.build();
        }
        return Description.NO_MATCH;
    }

    private static int occurrences(String haystack, String needle) {
        int count = 0;
        int start = 0;
        while ((start = haystack.indexOf(needle, start)) != -1) {
            ++count;
            start += needle.length();
        }
        return count;
    }

    @AutoValue
    static abstract class LenientFormatMethod {
        LenientFormatMethod() {
        }

        abstract Matcher<ExpressionTree> matcher();

        abstract int formatStringPosition();

        public static LenientFormatMethod create(Matcher<ExpressionTree> matcher, int formatStringPosition) {
            return new AutoValue_LenientFormatStringValidation_LenientFormatMethod(matcher, formatStringPosition);
        }
    }
}

