/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Optional;

@BugPattern(summary="Use Java's utility functional interfaces instead of Function<A, B> for primitive types.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class LambdaFunctionalInterface
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String JAVA_UTIL_FUNCTION_FUNCTION = "java.util.function.Function";
    private static final String JAVA_LANG_NUMBER = "java.lang.Number";
    private static final ImmutableMap<String, String> METHOD_MAPPINGS = ImmutableMap.builder().put("java.util.function.Function<java.lang.Double,java.lang.Double>", "java.util.function.DoubleFunction<Double>").put("java.util.function.Function<java.lang.Double,java.lang.Integer>", "java.util.function.DoubleToIntFunction").put("java.util.function.Function<java.lang.Double,java.lang.Long>", "java.util.function.DoubleToLongFunction").put("java.util.function.Function<java.lang.Double,T>", "java.util.function.DoubleFunction<T>").put("java.util.function.Function<java.lang.Integer,java.lang.Integer>", "java.util.function.IntFunction<Integer>").put("java.util.function.Function<java.lang.Integer,java.lang.Double>", "java.util.function.IntToDoubleFunction").put("java.util.function.Function<java.lang.Integer,java.lang.Long>", "java.util.function.IntToLongFunction").put("java.util.function.Function<java.lang.Integer,T>", "java.util.function.IntFunction<T>").put("java.util.function.Function<java.lang.Long,java.lang.Long>", "java.util.function.LongFunction<Long>").put("java.util.function.Function<java.lang.Long,java.lang.Integer>", "java.util.function.LongToIntFunction").put("java.util.function.Function<java.lang.Long,java.lang.Double>", "java.util.function.LongToDoubleFunction").put("java.util.function.Function<java.lang.Long,T>", "java.util.function.LongFunction<T>").put("java.util.function.Function<T,java.lang.Long>", "java.util.function.ToLongFunction<T>").put("java.util.function.Function<T,java.lang.Integer>", "java.util.function.ToIntFunction<T>").put("java.util.function.Function<T,java.lang.Double>", "java.util.function.ToDoubleFunction<T>").buildOrThrow();
    private static final ImmutableMap<String, String> APPLY_MAPPINGS = ImmutableMap.builder().put("java.util.function.DoubleToIntFunction", "applyAsInt").put("java.util.function.DoubleToLongFunction", "applyAsLong").put("java.util.function.IntToDoubleFunction", "applyAsDouble").put("java.util.function.IntToLongFunction", "applyAsLong").put("java.util.function.LongToIntFunction", "applyAsInt").put("java.util.function.LongToDoubleFunction", "applyAsDouble").put("java.util.function.ToIntFunction<T>", "applyAsInt").put("java.util.function.ToDoubleFunction<T>", "applyAsDouble").put("java.util.function.ToLongFunction<T>", "applyAsLong").buildOrThrow();

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol(tree);
        if (!ASTHelpers.canBeRemoved(methodSym, state)) {
            return Description.NO_MATCH;
        }
        ImmutableList params = tree.getParameters().stream().filter(param -> LambdaFunctionalInterface.hasFunctionAsArg(param, state)).filter(param -> LambdaFunctionalInterface.isFunctionArgSubtypeOf(param, 0, state.getTypeFromString(JAVA_LANG_NUMBER), state) || LambdaFunctionalInterface.isFunctionArgSubtypeOf(param, 1, state.getTypeFromString(JAVA_LANG_NUMBER), state)).collect(ImmutableList.toImmutableList());
        if (params.isEmpty() || !this.methodCallsMeetConditions(methodSym, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        for (Tree param2 : params) {
            LambdaFunctionalInterface.getMappingForFunctionFromTree(param2).ifPresent(mappedFunction -> {
                fixBuilder.addImport(LambdaFunctionalInterface.getImportName(mappedFunction));
                fixBuilder.replace(param2, LambdaFunctionalInterface.getFunctionName(mappedFunction) + " " + ASTHelpers.getSymbol((Tree)param).name);
                this.refactorInternalApplyMethods(tree, fixBuilder, param2, (String)mappedFunction);
            });
        }
        return this.describeMatch(tree, (Fix)fixBuilder.build());
    }

    private void refactorInternalApplyMethods(MethodTree tree, final SuggestedFix.Builder fixBuilder, final Tree param, String mappedFunction) {
        LambdaFunctionalInterface.getMappingForApply(mappedFunction).ifPresent(apply -> tree.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree callTree, Void unused) {
                Symbol receiverSym;
                if (ASTHelpers.getSymbol((MethodInvocationTree)callTree).name.contentEquals("apply") && (receiverSym = ASTHelpers.getSymbol(ASTHelpers.getReceiver(callTree))) != null && receiverSym.equals(ASTHelpers.getSymbol(param))) {
                    fixBuilder.replace(callTree.getMethodSelect(), receiverSym.name + "." + apply);
                }
                return (Void)super.visitMethodInvocation(callTree, unused);
            }
        }, null));
    }

    private boolean methodCallsMeetConditions(Symbol sym, VisitorState state) {
        ImmutableMultimap<String, MethodInvocationTree> methodCallMap = this.methodCallsForSymbol(sym, LambdaFunctionalInterface.getTopLevelClassTree(state));
        if (methodCallMap.isEmpty()) {
            return true;
        }
        for (MethodInvocationTree methodInvocationTree : methodCallMap.values()) {
            if (!methodInvocationTree.getArguments().stream().filter(a -> a.getKind().equals((Object)Tree.Kind.LAMBDA_EXPRESSION)).filter(a -> LambdaFunctionalInterface.hasFunctionAsArg(a, state)).noneMatch(a -> LambdaFunctionalInterface.isFunctionArgSubtypeOf(a, 0, state.getTypeFromString(JAVA_LANG_NUMBER), state) || LambdaFunctionalInterface.isFunctionArgSubtypeOf(a, 1, state.getTypeFromString(JAVA_LANG_NUMBER), state))) continue;
            return false;
        }
        return true;
    }

    private static ClassTree getTopLevelClassTree(VisitorState state) {
        return Streams.findLast(Streams.stream(state.getPath().iterator()).filter(ClassTree.class::isInstance).map(ClassTree.class::cast)).orElseThrow(() -> new IllegalArgumentException("No enclosing class found"));
    }

    private ImmutableMultimap<String, MethodInvocationTree> methodCallsForSymbol(final Symbol sym, ClassTree classTree) {
        final ImmutableMultimap.Builder methodMap = ImmutableMultimap.builder();
        classTree.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree callTree, Void unused) {
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(callTree);
                if (sym.equals(methodSymbol)) {
                    methodMap.put(methodSymbol.toString(), callTree);
                }
                return (Void)super.visitMethodInvocation(callTree, unused);
            }
        }, null);
        return methodMap.build();
    }

    private static boolean hasFunctionAsArg(Tree param, VisitorState state) {
        return ASTHelpers.isSameType(ASTHelpers.getType(param), state.getTypeFromString(JAVA_UTIL_FUNCTION_FUNCTION), state);
    }

    private static boolean isFunctionArgSubtypeOf(Tree param, int argIndex, Type type, VisitorState state) {
        return ASTHelpers.isSubtype(ASTHelpers.getType(param).getTypeArguments().get(argIndex), type, state);
    }

    private static Optional<String> getMappingForFunctionFromTree(Tree param) {
        return Optional.ofNullable(ASTHelpers.getType(param)).flatMap(t2 -> LambdaFunctionalInterface.getMappingForFunction(t2.toString()));
    }

    private static Optional<String> getMappingForFunction(String function) {
        return Optional.ofNullable(METHOD_MAPPINGS.get(function));
    }

    private static Optional<String> getMappingForApply(String apply) {
        return Optional.ofNullable(APPLY_MAPPINGS.get(apply));
    }

    private static String getFunctionName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1);
    }

    private static String getImportName(String fullyQualifiedName) {
        int cutPosition = fullyQualifiedName.indexOf(60);
        return cutPosition < 0 ? fullyQualifiedName : fullyQualifiedName.substring(0, cutPosition);
    }
}

