/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Optional;
import javax.annotation.Nullable;

@BugPattern(summary="Suggests alternatives to obsolete JDK classes.", severity=BugPattern.SeverityLevel.WARNING)
public class JdkObsolete
extends BugChecker
implements BugChecker.NewClassTreeMatcher,
BugChecker.ClassTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    static final ImmutableMap<String, Obsolete> OBSOLETE = ImmutableList.of(new Obsolete("java.util.LinkedList", "It is very rare for LinkedList to out-perform ArrayList or ArrayDeque. Avoid it unless you're willing to invest a lot of time into benchmarking. Caveat: LinkedList supports null elements, but ArrayDeque does not."){

        @Override
        Optional<Fix> fix(Tree tree, VisitorState state) {
            return JdkObsolete.linkedListFix(tree, state);
        }
    }, new Obsolete("java.util.Vector", "Vector performs synchronization that is usually unnecessary; prefer ArrayList."), new Obsolete("java.util.Hashtable", "Hashtable performs synchronization this is usually unnecessary; prefer LinkedHashMap."), new Obsolete("java.util.Stack", "Stack is a nonstandard class that predates the Java Collections Framework; prefer ArrayDeque. Note that the Stack methods push/pop/peek correspond to the Deque methods addFirst/removeFirst/peekFirst."), new Obsolete("java.lang.StringBuffer", "StringBuffer performs synchronization that is usually unnecessary; prefer StringBuilder."){

        @Override
        Optional<Fix> fix(Tree tree, VisitorState state) {
            return JdkObsolete.stringBufferFix(state);
        }
    }, new Obsolete("java.util.SortedSet", "SortedSet was replaced by NavigableSet in Java 6."), new Obsolete("java.util.SortedMap", "SortedMap was replaced by NavigableMap in Java 6."), new Obsolete("java.util.Dictionary", "Dictionary is a nonstandard class that predates the Java Collections Framework; use LinkedHashMap."), new Obsolete("java.util.Enumeration", "Enumeration is an ancient precursor to Iterator.")).stream().collect(ImmutableMap.toImmutableMap(Obsolete::qualifiedName, x -> x));
    static final Matcher<ExpressionTree> MATCHER_STRINGBUFFER = Matchers.anyOf(MethodMatchers.instanceMethod().onExactClass("java.util.regex.Matcher").named("appendTail").withParameters("java.lang.StringBuffer", new String[0]), MethodMatchers.instanceMethod().onExactClass("java.util.regex.Matcher").named("appendReplacement").withParameters("java.lang.StringBuffer", "java.lang.String"), MethodMatchers.instanceMethod().onExactClass("com.google.re2j.Matcher").named("appendTail").withParameters("java.lang.StringBuffer", new String[0]), MethodMatchers.instanceMethod().onExactClass("com.google.re2j.Matcher").named("appendReplacement").withParameters("java.lang.StringBuffer", "java.lang.String"));
    private static final Matcher<ExpressionTree> MOCKITO_MATCHER = MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("when");

    @Override
    public Description matchNewClass(NewClassTree tree, final VisitorState state) {
        Symbol.MethodSymbol constructor = ASTHelpers.getSymbol(tree);
        Symbol owner = constructor.owner;
        Description description = this.describeIfObsolete(tree.getClassBody() == null ? tree.getIdentifier() : null, owner.name.isEmpty() ? state.getTypes().directSupertypes(owner.asType()) : ImmutableList.of(owner.asType()), state);
        if (description == Description.NO_MATCH) {
            return Description.NO_MATCH;
        }
        if (owner.getQualifiedName().contentEquals("java.lang.StringBuffer")) {
            final boolean[] found = new boolean[]{false};
            new TreeScanner<Void, Void>(){

                @Override
                public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                    if (MATCHER_STRINGBUFFER.matches(tree, state)) {
                        found[0] = true;
                    }
                    return null;
                }
            }.scan(state.getPath().getCompilationUnit(), null);
            if (found[0]) {
                return Description.NO_MATCH;
            }
        }
        return description;
    }

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof NewClassTree && tree.equals(((NewClassTree)parent).getClassBody())) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol(tree);
        return this.describeIfObsolete(null, state.getTypes().directSupertypes((Type)symbol.asType()), state);
    }

    @Override
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        Type type = ASTHelpers.getType(tree.getQualifierExpression());
        if (type == null) {
            return Description.NO_MATCH;
        }
        return this.describeIfObsolete(tree.getQualifierExpression(), ImmutableList.of(type), state);
    }

    private Description describeIfObsolete(@Nullable Tree tree, Iterable<Type> types, VisitorState state) {
        for (Type type : types) {
            Obsolete obsolete = OBSOLETE.get(type.asElement().getQualifiedName().toString());
            if (obsolete == null || this.shouldSkip(state, type)) continue;
            Description.Builder description = this.buildDescription(state.getPath().getLeaf()).setMessage(obsolete.message());
            if (tree != null) {
                obsolete.fix(tree, state).ifPresent(description::addFix);
            }
            return description.build();
        }
        return Description.NO_MATCH;
    }

    @Nullable
    private static Type getMethodOrLambdaReturnType(VisitorState state) {
        for (Tree tree : state.getPath()) {
            switch (tree.getKind()) {
                case LAMBDA_EXPRESSION: {
                    return state.getTypes().findDescriptorType(ASTHelpers.getType(tree)).getReturnType();
                }
                case METHOD: {
                    return ASTHelpers.getType(tree).getReturnType();
                }
                case CLASS: {
                    return null;
                }
            }
        }
        return null;
    }

    @Nullable
    static Type getTargetType(VisitorState state) {
        Type type;
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof VariableTree || parent instanceof AssignmentTree) {
            type = ASTHelpers.getType(parent);
        } else if (parent instanceof ReturnTree || parent instanceof LambdaExpressionTree) {
            type = JdkObsolete.getMethodOrLambdaReturnType(state);
        } else {
            if (parent instanceof MethodInvocationTree) {
                MethodInvocationTree tree = (MethodInvocationTree)parent;
                int idx = tree.getArguments().indexOf(state.getPath().getLeaf());
                if (idx == -1) {
                    return null;
                }
                Type methodType = ASTHelpers.getType(tree.getMethodSelect());
                if (idx >= methodType.getParameterTypes().size()) {
                    return null;
                }
                return methodType.getParameterTypes().get(idx);
            }
            return null;
        }
        Tree tree = state.getPath().getLeaf();
        if (tree instanceof MemberReferenceTree) {
            type = state.getTypes().findDescriptorType(ASTHelpers.getType(tree)).getReturnType();
        }
        return type;
    }

    private static Optional<Fix> linkedListFix(Tree tree, VisitorState state) {
        Type type = JdkObsolete.getTargetType(state);
        if (type == null) {
            return Optional.empty();
        }
        Types types = state.getTypes();
        for (String replacement : ImmutableList.of("java.util.ArrayList", "java.util.ArrayDeque")) {
            Symbol sym = state.getSymbolFromString(replacement);
            if (sym == null || !types.isAssignable(types.erasure(sym.asType()), types.erasure(type))) continue;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            while (tree instanceof ParameterizedTypeTree) {
                tree = ((ParameterizedTypeTree)tree).getType();
            }
            fix.replace(tree, SuggestedFixes.qualifyType(state, fix, sym));
            return Optional.of(fix.build());
        }
        return Optional.empty();
    }

    private static Optional<Fix> stringBufferFix(VisitorState state) {
        Tree tree = state.getPath().getLeaf();
        if (!(tree instanceof NewClassTree)) {
            return Optional.empty();
        }
        NewClassTree newClassTree = (NewClassTree)tree;
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof VariableTree)) {
            return Optional.empty();
        }
        final VariableTree varTree = (VariableTree)parent;
        final Symbol.VarSymbol varSym = ASTHelpers.getSymbol(varTree);
        TreePath methodPath = JdkObsolete.findEnclosingMethod(state);
        if (methodPath == null) {
            return Optional.empty();
        }
        final boolean[] escape = new boolean[]{false};
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (varSym.equals(ASTHelpers.getSymbol(tree))) {
                    Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                    if (parent == varTree) {
                        return null;
                    }
                    if (!(parent instanceof MemberSelectTree) || ((MemberSelectTree)parent).getExpression() != tree) {
                        escape[0] = true;
                    }
                }
                return null;
            }
        }.scan(methodPath, (Void)null);
        if (escape[0]) {
            return Optional.empty();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder().replace(newClassTree.getIdentifier(), "StringBuilder");
        if (ASTHelpers.getStartPosition(varTree.getType()) != -1) {
            fix = fix.replace(varTree.getType(), "StringBuilder");
        }
        return Optional.of(fix.build());
    }

    @Nullable
    private static TreePath findEnclosingMethod(VisitorState state) {
        for (TreePath path = state.getPath(); path != null; path = path.getParentPath()) {
            switch (path.getLeaf().getKind()) {
                case METHOD: {
                    return path;
                }
                case LAMBDA_EXPRESSION: 
                case CLASS: {
                    return null;
                }
            }
        }
        return null;
    }

    private boolean shouldSkip(VisitorState state, Type type) {
        TreePath path = JdkObsolete.findEnclosingMethod(state);
        if (path == null) {
            return false;
        }
        MethodTree enclosingMethod = (MethodTree)path.getLeaf();
        if (enclosingMethod == null) {
            return false;
        }
        return JdkObsolete.implementingObsoleteMethod(enclosingMethod, state, type) || this.mockingObsoleteMethod(enclosingMethod, state, type);
    }

    private boolean mockingObsoleteMethod(MethodTree enclosingMethod, final VisitorState state, final Type type) {
        final boolean[] found = new boolean[]{false};
        enclosingMethod.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
                Type stubber;
                if (found[0]) {
                    return null;
                }
                if (MOCKITO_MATCHER.matches(node, state) && !(stubber = ASTHelpers.getReturnType(node)).getTypeArguments().isEmpty() && ASTHelpers.isSameType(Iterables.getOnlyElement(stubber.getTypeArguments()), type, state)) {
                    found[0] = true;
                }
                return (Void)super.visitMethodInvocation(node, null);
            }
        }, null);
        return found[0];
    }

    private static boolean implementingObsoleteMethod(MethodTree enclosingMethod, VisitorState state, Type type) {
        Symbol.MethodSymbol method = ASTHelpers.getSymbol(enclosingMethod);
        if (ASTHelpers.findSuperMethods(method, state.getTypes()).isEmpty()) {
            return false;
        }
        return ASTHelpers.isSameType(method.getReturnType(), type, state);
    }

    static class Obsolete {
        final String qualifiedName;
        final String message;

        Obsolete(String qualifiedName, String message) {
            this.qualifiedName = qualifiedName;
            this.message = message;
        }

        String qualifiedName() {
            return this.qualifiedName;
        }

        String message() {
            return this.message;
        }

        Optional<Fix> fix(Tree tree, VisitorState state) {
            return Optional.empty();
        }
    }
}

