/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CaseFormat;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.lang.invoke.CallSite;
import java.util.Optional;
import java.util.TreeSet;

@BugPattern(summary="The method for providing parameters was not found.", severity=BugPattern.SeverityLevel.ERROR)
public class JUnitParameterMethodNotFound
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<AnnotationTree> PARAMETERS_ANNOTATION_MATCHER = Matchers.isSameType("junitparams.Parameters");
    private static final MultiMatcher<ClassTree, AnnotationTree> PARAMETERIZED_TEST_RUNNER = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.hasArgumentWithValue("value", JUnitMatchers.isJUnit4TestRunnerOfType(ImmutableSet.of("junitparams.JUnitParamsRunner"))));
    private static final Matcher<MethodTree> ENCLOSING_CLASS_PARAMETERIZED_TEST_RUNNER_MATCHER = Matchers.enclosingClass(PARAMETERIZED_TEST_RUNNER);
    private static final Matcher<MethodTree> POSSIBLE_PARAMETERIZED_TEST_METHOD_MATCHER = Matchers.allOf(ENCLOSING_CLASS_PARAMETERIZED_TEST_RUNNER_MATCHER, JUnitMatchers.wouldRunInJUnit4);
    private static final String JUNIT_PARAMETER_METHOD_PREFIX = "parametersFor";

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Sets.SetView missingMethods;
        if (!POSSIBLE_PARAMETERIZED_TEST_METHOD_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Optional<AnnotationTree> parametersAnnotation = tree.getModifiers().getAnnotations().stream().filter(annotationTree -> PARAMETERS_ANNOTATION_MATCHER.matches((AnnotationTree)annotationTree, state)).findFirst();
        if (!parametersAnnotation.isPresent()) {
            return Description.NO_MATCH;
        }
        ImmutableSet<Object> methodsInSourceClass = ImmutableSet.of();
        TreeSet<CallSite> requiredMethods = new TreeSet<CallSite>();
        ImmutableList annotationsArguments = parametersAnnotation.get().getArguments().stream().filter(expressionTree -> expressionTree.getKind() == Tree.Kind.ASSIGNMENT).map(expressionTree -> (AssignmentTree)expressionTree).collect(ImmutableList.toImmutableList());
        if (annotationsArguments.isEmpty()) {
            requiredMethods.add((CallSite)((Object)(JUNIT_PARAMETER_METHOD_PREFIX + JUnitParameterMethodNotFound.toPascalCase(tree.getName().toString()))));
        } else {
            Optional<? extends AssignmentTree> paramMethodAssignmentTree = JUnitParameterMethodNotFound.getParamAssignmentTree(annotationsArguments, "method");
            if (paramMethodAssignmentTree.isPresent()) {
                String paramMethods = (String)ASTHelpers.constValue(paramMethodAssignmentTree.get().getExpression());
                Splitter.on(',').trimResults().splitToStream(paramMethods).forEach(requiredMethods::add);
                methodsInSourceClass = JUnitParameterMethodNotFound.getMethodIdentifiersInSourceAnnotation(annotationsArguments, state);
            }
        }
        if (methodsInSourceClass.isEmpty()) {
            methodsInSourceClass = JUnitParameterMethodNotFound.getAllMethodIdentifiersForType(JUnitParameterMethodNotFound.getClassType(tree), state);
        }
        if ((missingMethods = Sets.difference(requiredMethods, methodsInSourceClass)).isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("%s method(s) not found", String.join((CharSequence)",", missingMethods))).build();
    }

    private static Type getClassType(MethodTree tree) {
        return ASTHelpers.enclosingClass((Symbol)ASTHelpers.getSymbol((MethodTree)tree)).type;
    }

    private static ImmutableSet<String> getMethodIdentifiersInSourceAnnotation(ImmutableList<? extends AssignmentTree> annotationsArguments, VisitorState state) {
        Optional<? extends AssignmentTree> paramSourceAssignmentTree = JUnitParameterMethodNotFound.getParamAssignmentTree(annotationsArguments, "source");
        if (!paramSourceAssignmentTree.isPresent()) {
            return ImmutableSet.of();
        }
        Type.ClassType classType = (Type.ClassType)ASTHelpers.getType(paramSourceAssignmentTree.get().getExpression());
        Type typeArgument = (Type)((List)classType.getTypeArguments()).get(0);
        return JUnitParameterMethodNotFound.getAllMethodIdentifiersForType(typeArgument, state);
    }

    private static Optional<? extends AssignmentTree> getParamAssignmentTree(ImmutableList<? extends AssignmentTree> annotationsArguments, String parameterName) {
        return annotationsArguments.stream().filter(assignmentTree -> ((IdentifierTree)assignmentTree.getVariable()).getName().contentEquals(parameterName)).findFirst();
    }

    private static ImmutableSet<String> getAllMethodIdentifiersForType(Type type, VisitorState state) {
        return Streams.stream(state.getTypes().membersClosure(type, false).getSymbols()).filter(Symbol.MethodSymbol.class::isInstance).map(methodSymbol -> methodSymbol.getSimpleName().toString()).collect(ImmutableSet.toImmutableSet());
    }

    private static String toPascalCase(String methodName) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, methodName);
    }
}

