/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;

@BugPattern(summary="This looks like a test method but is not run; please add @Test and @Ignore, or, if this is a helper method, reduce its visibility.", severity=BugPattern.SeverityLevel.ERROR)
public class JUnit4TestNotRun
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String TEST_CLASS = "org.junit.Test";
    private static final String IGNORE_CLASS = "org.junit.Ignore";
    private static final String TEST_ANNOTATION = "@Test ";
    private static final String IGNORE_ANNOTATION = "@Ignore ";
    private final Matcher<MethodTree> possibleTestMethod = Matchers.allOf(Matchers.hasModifier(Modifier.PUBLIC), Matchers.methodReturns(Suppliers.VOID_TYPE), (t2, s2) -> t2.getParameters().stream().allMatch(v -> v.getModifiers().getAnnotations().stream().anyMatch(a -> this.isParameterAnnotation((AnnotationTree)a, s2))), Matchers.not(JUnitMatchers::hasJUnitAnnotation));
    private static final Supplier<Type> FROM_DATA_POINTS = Suppliers.typeFromString("org.junit.experimental.theories.FromDataPoints");
    private static final Matcher<Tree> NOT_STATIC = Matchers.not(Matchers.hasModifier(Modifier.STATIC));

    private boolean isParameterAnnotation(AnnotationTree annotation, VisitorState state) {
        Type annotationType = ASTHelpers.getType(annotation);
        return ASTHelpers.isSameType(annotationType, FROM_DATA_POINTS.get(state), state);
    }

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!JUnitMatchers.isJUnit4TestClass.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        final HashMap<Symbol.MethodSymbol, MethodTree> suspiciousMethods = new HashMap<Symbol.MethodSymbol, MethodTree>();
        for (Tree tree2 : tree.getMembers()) {
            MethodTree methodTree;
            if (!(tree2 instanceof MethodTree) || this.isSuppressed(tree2, state) || !this.possibleTestMethod.matches(methodTree = (MethodTree)tree2, state) || this.isSuppressed(tree, state)) continue;
            suspiciousMethods.put(ASTHelpers.getSymbol(methodTree), methodTree);
        }
        if (suspiciousMethods.isEmpty()) {
            return Description.NO_MATCH;
        }
        tree.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void unused) {
                suspiciousMethods.remove(ASTHelpers.getSymbol(methodInvocationTree));
                return (Void)super.visitMethodInvocation(methodInvocationTree, null);
            }
        }, null);
        for (MethodTree methodTree : suspiciousMethods.values()) {
            this.handleMethod(methodTree, state).ifPresent(state::reportMatch);
        }
        return Description.NO_MATCH;
    }

    private Optional<Description> handleMethod(MethodTree methodTree, VisitorState state) {
        if (JUnitMatchers.isJunit3TestCase.matches(methodTree, state)) {
            return Optional.of(this.describeFixes(methodTree, state));
        }
        List<? extends AnnotationTree> annotations = methodTree.getModifiers().getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            return Optional.empty();
        }
        if (NOT_STATIC.matches(methodTree, state) && JUnitMatchers.containsTestMethod(methodTree)) {
            return Optional.of(this.describeFixes(methodTree, state));
        }
        return Optional.empty();
    }

    private Description describeFixes(MethodTree methodTree, VisitorState state) {
        Optional<SuggestedFix> removeStatic = SuggestedFixes.removeModifiers(methodTree, state, Modifier.STATIC);
        SuggestedFix testFix = SuggestedFix.builder().merge((SuggestedFix)removeStatic.orElse(null)).addImport(TEST_CLASS).prefixWith(methodTree, TEST_ANNOTATION).build();
        SuggestedFix ignoreFix = SuggestedFix.builder().merge(testFix).addImport(IGNORE_CLASS).prefixWith(methodTree, IGNORE_ANNOTATION).build();
        SuggestedFix visibilityFix = SuggestedFix.builder().merge((SuggestedFix)SuggestedFixes.removeModifiers(methodTree, state, Modifier.PUBLIC).orElse(null)).merge((SuggestedFix)SuggestedFixes.addModifiers((Tree)methodTree, state, Modifier.PRIVATE).orElse(null)).build();
        String methodName = methodTree.getName().toString();
        if (methodName.startsWith("disabl") || methodName.startsWith("ignor")) {
            return this.buildDescription(methodTree).addFix(ignoreFix).addFix(testFix).addFix(visibilityFix).build();
        }
        return this.buildDescription(methodTree).addFix(testFix).addFix(ignoreFix).addFix(visibilityFix).build();
    }
}

