/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Some JUnit4 construct cannot be used in a JUnit3 context. Convert your class to JUnit4 style to use them.", severity=BugPattern.SeverityLevel.WARNING)
public class JUnit4ClassUsedInJUnit3
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.AnnotationTreeMatcher {
    private static final Matcher<ExpressionTree> ASSUME_CHECK = Matchers.allOf(MethodMatchers.staticMethod().onClass("org.junit.Assume").withAnyName(), Matchers.enclosingClass(JUnitMatchers.isJUnit3TestClass));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!ASSUME_CHECK.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.makeDescription("Assume", tree);
    }

    @Override
    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        if (!Matchers.enclosingClass(JUnitMatchers.isJUnit3TestClass).matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (Matchers.isType("org.junit.Ignore").matches(tree, state)) {
            return this.makeDescription("@Ignore", tree);
        }
        if (Matchers.isType("org.junit.Rule").matches(tree, state)) {
            return this.makeDescription("@Rule", tree);
        }
        return Description.NO_MATCH;
    }

    private Description makeDescription(String rejectedJUnit4, Tree tree) {
        Description.Builder builder = this.buildDescription(tree).setMessage(String.format("%s cannot be used inside a JUnit3 class. Convert your class to JUnit4 style.", rejectedJUnit4));
        return builder.build();
    }
}

