/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

@BugPattern(summary="This use of isInstance will always evaluate to false.", severity=BugPattern.SeverityLevel.ERROR)
public final class IsInstanceIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final Matcher<ExpressionTree> IS_INSTANCE = Matchers.instanceMethod().onExactClass("java.lang.Class").named("isInstance");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!IS_INSTANCE.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Type receiverType = IsInstanceIncompatibleType.classTypeArgument(tree);
        if (receiverType == null) {
            return Description.NO_MATCH;
        }
        Type argumentType = ASTHelpers.getType(tree.getArguments().get(0));
        return ASTHelpers.isCastable(argumentType, receiverType, state) ? Description.NO_MATCH : this.buildMessage(argumentType, receiverType, tree, state);
    }

    @Override
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        if (!IS_INSTANCE.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Type type = state.getTypes().findDescriptorType(ASTHelpers.getType(tree));
        Type receiverType = IsInstanceIncompatibleType.classTypeArgument(tree);
        if (receiverType == null) {
            return Description.NO_MATCH;
        }
        Type argumentType = ASTHelpers.getUpperBound(type.getParameterTypes().get(0), state.getTypes());
        return ASTHelpers.isCastable(argumentType, receiverType, state) ? Description.NO_MATCH : this.buildMessage(argumentType, receiverType, tree, state);
    }

    private static @Nullable Type classTypeArgument(ExpressionTree tree) {
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        if (receiver == null) {
            return null;
        }
        List<Type> receiverTypeArguments = ASTHelpers.getType(receiver).getTypeArguments();
        return !receiverTypeArguments.isEmpty() ? Iterables.getOnlyElement(receiverTypeArguments) : null;
    }

    private Description buildMessage(Type type1, Type type2, Tree tree, VisitorState state) {
        return this.buildDescription(tree).setMessage(String.format("This expression will always evaluate to false because %s cannot be cast to %s", Signatures.prettyType(state.getTypes().erasure(type1)), Signatures.prettyType(state.getTypes().erasure(type2)))).build();
    }
}

