/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import java.time.DateTimeException;
import java.time.ZoneId;

@BugPattern(summary="Invalid zone identifier. ZoneId.of(String) will throw exception at runtime.", severity=BugPattern.SeverityLevel.ERROR)
public class InvalidZoneId
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> METHOD_MATCHER = MethodMatchers.staticMethod().onClass("java.time.ZoneId").named("of").withParameters("java.lang.String", new String[0]);

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!METHOD_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        String value = ASTHelpers.constValue(Iterables.getOnlyElement(tree.getArguments()), String.class);
        if (value == null) {
            return Description.NO_MATCH;
        }
        if (InvalidZoneId.isValidID(value)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static boolean isValidID(String value) {
        try {
            ZoneId.of(value);
        }
        catch (DateTimeException e) {
            return false;
        }
        return true;
    }
}

