/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.InputStream;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Please also override int read(byte[], int, int), otherwise multi-byte reads from this input stream are likely to be slow.", severity=BugPattern.SeverityLevel.WARNING, tags={"Performance"})
public class InputStreamSlowMultibyteRead
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> IS_INPUT_STREAM = Matchers.isSubtypeOf(InputStream.class);
    private static final Matcher<MethodTree> READ_INT_METHOD = Matchers.allOf(Matchers.methodIsNamed("read"), Matchers.methodReturns(Suppliers.INT_TYPE), Matchers.methodHasArity(0));
    private static final Matcher<MethodTree> RETURNS_CONSTANT = Matchers.singleStatementReturnMatcher((e, s2) -> ASTHelpers.constValue(e) != null);
    private static final Supplier<Name> READ = VisitorState.memoize(state -> state.getName("read"));

    @Override
    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!IS_INPUT_STREAM.matches(classTree, state)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol thisClassSymbol = ASTHelpers.getSymbol(classTree);
        if (((Symbol)thisClassSymbol).getKind() != ElementKind.CLASS) {
            return Description.NO_MATCH;
        }
        MethodTree readByteMethod = classTree.getMembers().stream().filter(MethodTree.class::isInstance).map(MethodTree.class::cast).filter(m4 -> READ_INT_METHOD.matches((MethodTree)m4, state)).findFirst().orElse(null);
        if (readByteMethod == null) {
            return Description.NO_MATCH;
        }
        Type byteArrayType = state.arrayTypeForType(state.getSymtab().byteType);
        Type.JCPrimitiveType intType = state.getSymtab().intType;
        Symbol.MethodSymbol multiByteReadMethod = ASTHelpers.resolveExistingMethod(state, thisClassSymbol, READ.get(state), ImmutableList.of(byteArrayType, intType, intType), ImmutableList.of());
        return multiByteReadMethod.owner.equals(thisClassSymbol) ? Description.NO_MATCH : this.maybeMatchReadByte(readByteMethod, state);
    }

    private Description maybeMatchReadByte(MethodTree readByteMethod, VisitorState state) {
        if (RETURNS_CONSTANT.matches(readByteMethod, state)) {
            return Description.NO_MATCH;
        }
        TreePath enclosingPath = ASTHelpers.findPathFromEnclosingNodeToTopLevel(state.getPath(), ClassTree.class);
        while (enclosingPath != null) {
            ClassTree klazz = (ClassTree)enclosingPath.getLeaf();
            if (JUnitMatchers.isTestCaseDescendant.matches(klazz, state) || Matchers.hasAnnotation("org.junit.runner.RunWith").matches(klazz, state)) {
                return Description.NO_MATCH;
            }
            enclosingPath = ASTHelpers.findPathFromEnclosingNodeToTopLevel(enclosingPath, ClassTree.class);
        }
        return this.describeMatch(readByteMethod);
    }
}

