/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="BugChecker constructors should be marked @Inject.")
public final class InjectOnBugCheckers
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        if (!symbol.isConstructor()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isGeneratedConstructor(tree)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasDirectAnnotationWithSimpleName(tree, "Inject")) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSubtype(symbol.owner.type, state.getTypeFromString(BugChecker.class.getCanonicalName()), state)) {
            return Description.NO_MATCH;
        }
        if (tree.getParameters().isEmpty() || !tree.getParameters().stream().allMatch(p -> ASTHelpers.isSubtype(ASTHelpers.getType(p), state.getTypeFromString(ErrorProneFlags.class.getCanonicalName()), state))) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        return this.describeMatch(tree, (Fix)fix.prefixWith(tree, "@" + SuggestedFixes.qualifyType(state, fix, "javax.inject.Inject") + " ").build());
    }
}

