/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.Nullable;

@BugPattern(summary="This method always recurses, and will cause a StackOverflowError", severity=BugPattern.SeverityLevel.ERROR)
public class InfiniteRecursion
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private final boolean matchFirstOfMultipleStatements;

    @Inject
    public InfiniteRecursion(ErrorProneFlags flags) {
        this.matchFirstOfMultipleStatements = flags.getBoolean("InfiniteRecursion:MatchFirstOfMultipleStatements").orElse(true);
    }

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getBody() == null || tree.getBody().getStatements().isEmpty()) {
            return Description.NO_MATCH;
        }
        if (!this.matchFirstOfMultipleStatements && tree.getBody().getStatements().size() > 1) {
            return Description.NO_MATCH;
        }
        Tree statement = tree.getBody().getStatements().get(0);
        MethodInvocationTree invocation = statement.accept(new SimpleTreeVisitor<MethodInvocationTree, Void>(){

            @Override
            public MethodInvocationTree visitExpressionStatement(ExpressionStatementTree tree, Void unused) {
                return (MethodInvocationTree)this.visit(tree.getExpression(), null);
            }

            @Override
            public MethodInvocationTree visitParenthesized(ParenthesizedTree tree, Void unused) {
                return (MethodInvocationTree)this.visit(tree.getExpression(), null);
            }

            @Override
            public MethodInvocationTree visitReturn(ReturnTree tree, Void unused) {
                return (MethodInvocationTree)this.visit(tree.getExpression(), null);
            }

            @Override
            public MethodInvocationTree visitTypeCast(TypeCastTree tree, Void unused) {
                return (MethodInvocationTree)this.visit(tree.getExpression(), null);
            }

            @Override
            protected @Nullable MethodInvocationTree defaultAction(Tree tree, Void unused) {
                return tree instanceof MethodInvocationTree ? (MethodInvocationTree)tree : null;
            }
        }, null);
        if (invocation == null) {
            return Description.NO_MATCH;
        }
        ExpressionTree select = invocation.getMethodSelect();
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
        if (!sym.equals(ASTHelpers.getSymbol(invocation))) {
            return Description.NO_MATCH;
        }
        if (!sym.isStatic()) {
            switch (select.getKind()) {
                case IDENTIFIER: {
                    break;
                }
                case MEMBER_SELECT: {
                    ExpressionTree receiver = ((MemberSelectTree)select).getExpression();
                    if (receiver.getKind() != Tree.Kind.IDENTIFIER) {
                        return Description.NO_MATCH;
                    }
                    if (((IdentifierTree)receiver).getName().contentEquals("this")) break;
                    return Description.NO_MATCH;
                }
                default: {
                    return Description.NO_MATCH;
                }
            }
        }
        return this.describeMatch(statement);
    }
}

