/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

@BugPattern(summary="'main' methods must be public, static, and void", severity=BugPattern.SeverityLevel.WARNING)
public final class IncorrectMainMethod
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final ImmutableSet<Modifier> REQUIRED_MODIFIERS = Sets.immutableEnumSet((Enum)Modifier.PUBLIC, (Enum[])new Modifier[]{Modifier.STATIC});

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!tree.getName().contentEquals("main")) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
        if (((List)sym.getParameters()).size() != 1) {
            return Description.NO_MATCH;
        }
        TypeMirror type = ((Symbol.VarSymbol)Iterables.getOnlyElement(sym.getParameters())).asType();
        Types types = state.getTypes();
        Symtab symtab = state.getSymtab();
        if (!types.isArray((Type)type) || !types.isSameType(types.elemtype((Type)type), symtab.stringType)) {
            return Description.NO_MATCH;
        }
        if (sym.getModifiers().containsAll(REQUIRED_MODIFIERS) && types.isSameType(ASTHelpers.getType(tree.getReturnType()), symtab.voidType)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder().replace(tree.getReturnType(), "void");
        SuggestedFixes.removeModifiers(tree, state, Modifier.PROTECTED, Modifier.PRIVATE).ifPresent(fix::merge);
        SuggestedFixes.addModifiers((Tree)tree, tree.getModifiers(), state, REQUIRED_MODIFIERS).ifPresent(fix::merge);
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

