/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.Table;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;

public final class ImmutableCollections {
    public static final ImmutableMap<String, String> MUTABLE_TO_IMMUTABLE_CLASS_NAME_MAP = ImmutableMap.builder().put(BiMap.class.getName(), ImmutableBiMap.class.getName()).put(ListMultimap.class.getName(), ImmutableListMultimap.class.getName()).put(Multimap.class.getName(), ImmutableMultimap.class.getName()).put(Multiset.class.getName(), ImmutableMultiset.class.getName()).put(RangeMap.class.getName(), ImmutableRangeMap.class.getName()).put(RangeSet.class.getName(), ImmutableRangeSet.class.getName()).put(SetMultimap.class.getName(), ImmutableSetMultimap.class.getName()).put(SortedMultiset.class.getName(), ImmutableSortedMultiset.class.getName()).put(Table.class.getName(), ImmutableTable.class.getName()).put(Collection.class.getName(), ImmutableCollection.class.getName()).put(List.class.getName(), ImmutableList.class.getName()).put(Map.class.getName(), ImmutableMap.class.getName()).put(NavigableMap.class.getName(), ImmutableSortedMap.class.getName()).put(NavigableSet.class.getName(), ImmutableSortedSet.class.getName()).put(Set.class.getName(), ImmutableSet.class.getName()).put(EnumSet.class.getName(), ImmutableSet.class.getName()).put(ArrayList.class.getName(), ImmutableList.class.getName()).put(HashMap.class.getName(), ImmutableMap.class.getName()).put(HashSet.class.getName(), ImmutableSet.class.getName()).put(EnumMap.class.getName(), ImmutableMap.class.getName()).buildOrThrow();

    private ImmutableCollections() {
    }

    public static boolean isImmutableType(Type type) {
        return MUTABLE_TO_IMMUTABLE_CLASS_NAME_MAP.containsValue(ImmutableCollections.getTypeQualifiedName(type));
    }

    static Optional<String> mutableToImmutable(String fullyQualifiedClassName) {
        return Optional.ofNullable(MUTABLE_TO_IMMUTABLE_CLASS_NAME_MAP.get(fullyQualifiedClassName));
    }

    private static String getTypeQualifiedName(Type type) {
        return type.tsym.getQualifiedName().toString();
    }
}

