/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="IdentityHashMap usage shouldn't be intermingled with Map", severity=BugPattern.SeverityLevel.WARNING)
public class IdentityHashMapUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.AssignmentTreeMatcher,
BugChecker.VariableTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final String IDENTITY_HASH_MAP = "java.util.IdentityHashMap";
    private static final Matcher<ExpressionTree> IHM_ONE_ARG_METHODS = MethodMatchers.instanceMethod().onExactClass("java.util.IdentityHashMap").namedAnyOf("equals", "putAll");
    private static final Matcher<ExpressionTree> IHM_CTOR_MAP_ARG = MethodMatchers.constructor().forClass("java.util.IdentityHashMap").withParameters("java.util.Map", new String[0]);
    private static final Supplier<Type> JAVA_UTIL_IDENTITYHASHMAP = VisitorState.memoize(state -> state.getTypeFromString(IDENTITY_HASH_MAP));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (IHM_ONE_ARG_METHODS.matches(tree, state) && !ASTHelpers.isSameType(ASTHelpers.getType(tree.getArguments().get(0)), JAVA_UTIL_IDENTITYHASHMAP.get(state), state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        Type ihmType = JAVA_UTIL_IDENTITYHASHMAP.get(state);
        if (!ASTHelpers.isSameType(ASTHelpers.getType(tree.getExpression()), ihmType, state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType(ASTHelpers.getType(tree.getVariable()), ihmType, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (tree.getInitializer() == null) {
            return Description.NO_MATCH;
        }
        Type ihmType = JAVA_UTIL_IDENTITYHASHMAP.get(state);
        if (ASTHelpers.isSameType(ASTHelpers.getType(tree.getType()), ihmType, state)) {
            return Description.NO_MATCH;
        }
        Type type = ASTHelpers.getType(tree.getInitializer());
        if (ASTHelpers.isSameType(type, ihmType, state)) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            fix.replace(tree.getType(), SuggestedFixes.qualifyType(state, fix, type));
            return this.describeMatch(tree, (Fix)fix.build());
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (IHM_CTOR_MAP_ARG.matches(tree, state) && !ASTHelpers.isSameType(ASTHelpers.getType(tree.getArguments().get(0)), JAVA_UTIL_IDENTITYHASHMAP.get(state), state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

