/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Calling getClass() on an object of type Class returns the Class object for java.lang.Class; you probably meant to operate on the object directly", severity=BugPattern.SeverityLevel.ERROR)
public class GetClassOnClass
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> getClassMethodMatcher = Matchers.instanceMethod().onExactClass("java.lang.Class").named("getClass");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (getClassMethodMatcher.matches(tree, state)) {
            String methodInvoker = state.getSourceForNode(ASTHelpers.getReceiver(tree));
            SuggestedFix removeGetClass = SuggestedFix.replace(tree, methodInvoker);
            SuggestedFix changeToClassDotClass = SuggestedFix.replace(tree, "Class.class");
            return this.buildDescription(tree).addFix(removeGetClass).addFix(changeToClassDotClass).build();
        }
        return Description.NO_MATCH;
    }
}

