/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Optional;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ForkJoinTask;

@BugPattern(summary="Return value of methods returning Future must be checked. Ignoring returned Futures suppresses exceptions thrown from the code that completes the Future.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"}, documentSuppression=false)
public final class FutureReturnValueIgnored
extends AbstractReturnValueIgnored
implements BugChecker.ReturnTreeMatcher {
    private static final Matcher<ExpressionTree> IGNORED_METHODS = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOf(ForkJoinTask.class.getName()).named("fork").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf(CompletionService.class.getName()).named("submit"), MethodMatchers.instanceMethod().onDescendantOf("com.intellij.openapi.application.Application").named("executeOnPooledThread"), MethodMatchers.instanceMethod().onDescendantOf("io.netty.util.concurrent.Future").namedAnyOf("addListener", "addListeners", "removeListener", "removeListeners", "sync", "syncUninterruptibly", "await", "awaitUninterruptibly"), MethodMatchers.instanceMethod().onDescendantOf("io.netty.util.concurrent.Promise").namedAnyOf("setSuccess", "setFailure"), MethodMatchers.instanceMethod().onExactClass("java.util.concurrent.CompletableFuture").namedAnyOf("exceptionally", "completeAsync", "orTimeout", "completeOnTimeout"));
    private static final Matcher<ExpressionTree> MATCHER = new Matcher<ExpressionTree>(){

        @Override
        public boolean matches(ExpressionTree tree, VisitorState state) {
            Type futureType = JAVA_UTIL_CONCURRENT_FUTURE.get(state);
            if (futureType == null) {
                return false;
            }
            Symbol untypedSymbol = ASTHelpers.getSymbol(tree);
            if (!(untypedSymbol instanceof Symbol.MethodSymbol)) {
                Type resultType = ASTHelpers.getResultType(tree);
                return resultType != null && ASTHelpers.isSubtype(ASTHelpers.getUpperBound(resultType, state.getTypes()), futureType, state);
            }
            Symbol.MethodSymbol sym = (Symbol.MethodSymbol)untypedSymbol;
            if (ASTHelpers.hasAnnotation((Symbol)sym, CanIgnoreReturnValue.class, state)) {
                return false;
            }
            for (Symbol.MethodSymbol superSym : ASTHelpers.findSuperMethods(sym, state.getTypes())) {
                if (!ASTHelpers.hasAnnotation((Symbol)superSym, CanIgnoreReturnValue.class, state) || !ASTHelpers.isSubtype(ASTHelpers.getUpperBound(superSym.getReturnType(), state.getTypes()), futureType, state)) continue;
                return false;
            }
            if (IGNORED_METHODS.matches(tree, state)) {
                return false;
            }
            Type returnType = sym.getReturnType();
            return ASTHelpers.isSubtype(ASTHelpers.getUpperBound(returnType, state.getTypes()), futureType, state);
        }
    };
    private final Supplier<Type> futureType = Suppliers.typeFromString("java.util.concurrent.Future");
    private static final Supplier<Type> JAVA_UTIL_CONCURRENT_FUTURE = VisitorState.memoize(state -> state.getTypeFromString("java.util.concurrent.Future"));

    public Matcher<ExpressionTree> specializedMatcher() {
        return MATCHER;
    }

    @Override
    protected Optional<Type> lostType(VisitorState state) {
        return Optional.ofNullable(this.futureType.get(state));
    }

    @Override
    protected String lostTypeMessage(String returnedType, String declaredReturnType) {
        return String.format("Returning %s from method that returns %s. Errors from the returned future may be ignored.", returnedType, declaredReturnType);
    }
}

