/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.stream.Collectors;

@BugPattern(summary="Overloads will be ambiguous when passing lambda arguments.", severity=BugPattern.SeverityLevel.WARNING)
public class FunctionalInterfaceClash
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        Symbol.MethodSymbol msym;
        Symbol.ClassSymbol origin = ASTHelpers.getSymbol(tree);
        Types types = state.getTypes();
        HashMultimap<String, Symbol.MethodSymbol> methods = HashMultimap.create();
        for (Symbol symbol : types.membersClosure(ASTHelpers.getType(tree), false).getSymbols()) {
            if (!(symbol instanceof Symbol.MethodSymbol) || (msym = (Symbol.MethodSymbol)symbol).getParameters().stream().noneMatch(p -> FunctionalInterfaceClash.maybeFunctionalInterface(p.type, types, state)) || msym.isConstructor() && !msym.owner.equals(origin)) continue;
            methods.put(FunctionalInterfaceClash.functionalInterfaceSignature(state, msym), msym);
        }
        for (Tree tree2 : tree.getMembers()) {
            if (!(tree2 instanceof MethodTree) || (msym = ASTHelpers.getSymbol((MethodTree)tree2)).getParameters().stream().noneMatch(p -> FunctionalInterfaceClash.maybeFunctionalInterface(p.type, types, state))) continue;
            ArrayList clash = new ArrayList(methods.removeAll(FunctionalInterfaceClash.functionalInterfaceSignature(state, msym)));
            ArrayDeque<Symbol.MethodSymbol> worklist = new ArrayDeque<Symbol.MethodSymbol>();
            worklist.push(msym);
            clash.remove(msym);
            while (!worklist.isEmpty()) {
                Symbol.MethodSymbol msym2 = (Symbol.MethodSymbol)worklist.removeFirst();
                ImmutableList overrides = clash.stream().filter(m4 -> msym2.overrides((Symbol)m4, origin, types, false)).collect(ImmutableList.toImmutableList());
                worklist.addAll(overrides);
                clash.removeAll(overrides);
            }
            if (clash.isEmpty() || ASTHelpers.findSuperMethod(msym, types).isPresent() && clash.stream().anyMatch(methodSymbol -> ASTHelpers.findSuperMethod(methodSymbol, types).isPresent()) || this.isSuppressed(tree2, state)) continue;
            String message = "When passing lambda arguments to this function, callers will need a cast to disambiguate with: " + clash.stream().map(m4 -> "\n    " + Signatures.prettyMethodSignature(origin, m4)).sorted().collect(Collectors.joining(""));
            state.reportMatch(this.buildDescription(tree2).setMessage(message).build());
        }
        return Description.NO_MATCH;
    }

    private static String functionalInterfaceSignature(VisitorState state, Symbol.MethodSymbol msym) {
        return String.format("%s(%s)", msym.getSimpleName(), msym.getParameters().stream().map(p -> FunctionalInterfaceClash.functionalInterfaceSignature(state, p.type)).collect(Collectors.joining(",")));
    }

    private static String functionalInterfaceSignature(VisitorState state, Type type) {
        Types types = state.getTypes();
        if (!FunctionalInterfaceClash.maybeFunctionalInterface(type, types, state)) {
            return Signatures.descriptor(type, types);
        }
        Type descriptorType = types.findDescriptorType(type);
        List<Type> fiparams = descriptorType.getParameterTypes();
        String result = fiparams.isEmpty() ? Signatures.descriptor(descriptorType.getReturnType(), types) : "_";
        return String.format("(%s)->%s", fiparams.stream().map(t2 -> Signatures.descriptor(t2, types)).collect(Collectors.joining(",")), result);
    }

    private static boolean maybeFunctionalInterface(Type type, Types types, VisitorState state) {
        try {
            return types.isFunctionalInterface(type);
        }
        catch (Symbol.CompletionFailure e) {
            Check.instance(state.context).completionError((JCDiagnostic.DiagnosticPosition)((Object)state.getPath().getLeaf()), e);
            return false;
        }
    }
}

