/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CharMatcher;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.LiteralTree;
import com.sun.tools.javac.code.Type;
import java.math.BigDecimal;

@BugPattern(summary="Floating point literal loses precision", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class FloatingPointLiteralPrecision
extends BugChecker
implements BugChecker.LiteralTreeMatcher {
    private static final int REPLACEMENT_MAX_MULTIPLIER = 3;

    @Override
    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        BigDecimal exact;
        String suffix;
        BigDecimal value;
        Type type = ASTHelpers.getType(tree);
        if (type == null) {
            return Description.NO_MATCH;
        }
        switch (type.getKind()) {
            case DOUBLE: {
                value = new BigDecimal(Double.toString(ASTHelpers.constValue(tree, Double.class)));
                suffix = "";
                break;
            }
            case FLOAT: {
                value = new BigDecimal(Float.toString(ASTHelpers.constValue(tree, Float.class).floatValue()));
                suffix = "f";
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        String source = state.getSourceForNode(tree);
        switch (source.charAt(source.length() - 1)) {
            case 'D': 
            case 'F': 
            case 'd': 
            case 'f': {
                source = source.substring(0, source.length() - 1);
                break;
            }
        }
        source = CharMatcher.is('_').removeFrom(source);
        try {
            exact = new BigDecimal(source);
        }
        catch (NumberFormatException e) {
            return Description.NO_MATCH;
        }
        if (exact.compareTo(value) == 0) {
            return Description.NO_MATCH;
        }
        String replacement = value + suffix;
        if (replacement.length() > 3 * source.length()) {
            return this.describeMatch(tree);
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree, replacement));
    }
}

