/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import java.util.Set;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Do not override finalize", severity=BugPattern.SeverityLevel.WARNING)
public class Finalize
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!tree.getName().contentEquals("finalize")) {
            return Description.NO_MATCH;
        }
        if (!tree.getParameters().isEmpty()) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isVoidType(ASTHelpers.getType(tree.getReturnType()), state)) {
            return Description.NO_MATCH;
        }
        Set<Modifier> modifiers = ASTHelpers.getSymbol(tree).getModifiers();
        if (!modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PUBLIC)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

