/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafety;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

@BugPattern(summary="A final field initialized at compile-time with an instance of an immutable type can be static.", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class FieldCanBeStatic
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Supplier<ImmutableSet<Name>> EXEMPTING_VARIABLE_ANNOTATIONS = VisitorState.memoize(s2 -> Stream.of("com.google.inject.testing.fieldbinder.Bind").map(s2::getName).collect(ImmutableSet.toImmutableSet()));
    private final WellKnownMutability wellKnownMutability;
    private final ConstantExpressions constantExpressions;
    private static final long RECORD_FLAG = 0x2000000000000000L;
    private static final Pattern LOWER_CAMEL_PATTERN = Pattern.compile("[a-z][a-zA-Z0-9]+");

    @Inject
    public FieldCanBeStatic(ErrorProneFlags flags) {
        this.wellKnownMutability = WellKnownMutability.fromFlags(flags);
        this.constantExpressions = ConstantExpressions.fromFlags(flags);
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol(tree);
        if (!ASTHelpers.canBeRemoved(symbol) || !tree.getModifiers().getFlags().contains((Object)Modifier.FINAL) || symbol.isStatic() || !symbol.getKind().equals((Object)ElementKind.FIELD) || (symbol.flags() & 0x2000000000000000L) == 0x2000000000000000L) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol enclClass = symbol.owner.enclClass();
        if (enclClass == null) {
            return Description.NO_MATCH;
        }
        if (!enclClass.getNestingKind().equals((Object)NestingKind.TOP_LEVEL) && !enclClass.isStatic() && symbol.getConstantValue() == null) {
            return Description.NO_MATCH;
        }
        if (!this.isTypeKnownImmutable(ASTHelpers.getType(tree), state)) {
            return Description.NO_MATCH;
        }
        if (tree.getInitializer() == null || !this.isPure(tree.getInitializer(), state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.annotationsAmong(symbol, (Set<? extends Name>)EXEMPTING_VARIABLE_ANNOTATIONS.get(state), state).isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = SuggestedFix.builder().merge(this.renameVariable(tree, state)).merge(SuggestedFixes.addModifiers((Tree)tree, state, Modifier.STATIC).orElse(SuggestedFix.emptyFix())).build();
        return this.describeMatch(tree, (Fix)fix);
    }

    private SuggestedFix renameVariable(VariableTree variableTree, VisitorState state) {
        String name = variableTree.getName().toString();
        if (!LOWER_CAMEL_PATTERN.matcher(name).matches()) {
            return SuggestedFix.emptyFix();
        }
        final String replacement = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, variableTree.getName().toString());
        int typeEndPos = state.getEndPosition(variableTree.getType());
        int searchOffset = typeEndPos - ((JCTree)((Object)variableTree)).getStartPosition();
        int pos = ((JCTree)((Object)variableTree)).getStartPosition() + state.getSourceForNode(variableTree).indexOf(name, searchOffset);
        final SuggestedFix.Builder fix = SuggestedFix.builder().replace(pos, pos + name.length(), replacement);
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol(variableTree);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitIdentifier(tree, null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitMemberSelect(tree, null);
            }

            private void handle(Tree tree) {
                if (sym.equals(ASTHelpers.getSymbol(tree))) {
                    fix.replace(tree, replacement);
                }
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return fix.build();
    }

    private boolean isPure(ExpressionTree initializer, VisitorState state) {
        return this.constantExpressions.constantExpression(initializer, state).map(FieldCanBeStatic::isStatic).orElse(false);
    }

    private static boolean isStatic(ConstantExpressions.ConstantExpression expression) {
        final AtomicBoolean staticable = new AtomicBoolean(true);
        expression.accept(new ConstantExpressions.ConstantExpressionVisitor(){

            @Override
            public void visitIdentifier(Symbol identifier) {
                if (!(identifier instanceof Symbol.ClassSymbol) && !ASTHelpers.isStatic(identifier)) {
                    staticable.set(false);
                }
            }
        });
        return staticable.get();
    }

    private boolean isTypeKnownImmutable(Type type, VisitorState state) {
        ThreadSafety threadSafety = ThreadSafety.builder().setPurpose(ThreadSafety.Purpose.FOR_IMMUTABLE_CHECKER).knownTypes(this.wellKnownMutability).acceptedAnnotations(ImmutableSet.of(Immutable.class.getName(), AutoValue.class.getName())).markerAnnotations(ImmutableSet.of()).build(state);
        return !threadSafety.isThreadSafeType(true, threadSafety.threadSafeTypeParametersInScope(type.tsym), type).isPresent();
    }
}

