/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@BugPattern(summary="Prefer assertThrows to ExpectedException", severity=BugPattern.SeverityLevel.WARNING)
public class ExpectedExceptionChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    static final Matcher<StatementTree> MATCHER = Matchers.expressionStatement(MethodMatchers.instanceMethod().onExactClass("org.junit.rules.ExpectedException").withNameMatching(Pattern.compile("expect.*")));
    static final Matcher<ExpressionTree> IS_A = MethodMatchers.staticMethod().onClassAny("org.hamcrest.Matchers", "org.hamcrest.CoreMatchers", "org.hamcrest.core.Is").withSignature("<T>isA(java.lang.Class<T>)");
    static final Matcher<StatementTree> FAIL_MATCHER = Matchers.anyOf(Matchers.throwStatement(Matchers.anything()), Matchers.expressionStatement(MethodMatchers.staticMethod().anyClass().named("fail")));
    private static final Matcher<StatementTree> TRUTH_ASSERT_THAT = Matchers.expressionStatement(Matchers.toType(MethodInvocationTree.class, Matchers.receiverOfInvocation(Matchers.anyOf(MethodMatchers.staticMethod().onClass("com.google.common.truth.Truth").namedAnyOf("assertThat"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that")))));
    private static final Supplier<Symbol> ORG_HAMCREST_MATCHER_SYMBOL = VisitorState.memoize(state -> state.getSymbolFromString("org.hamcrest.Matcher"));
    private static final Supplier<Type> ORG_HAMCREST_MATCHER_TYPE = VisitorState.memoize(state -> state.getTypeFromString("org.hamcrest.Matcher"));

    @Override
    public Description matchMethod(final MethodTree tree, final VisitorState state) {
        if (tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        tree.getBody().accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitBlock(BlockTree block, Void unused) {
                Description description = ExpectedExceptionChecker.this.scanBlock(tree, block, state);
                if (description != Description.NO_MATCH) {
                    state.reportMatch(description);
                }
                return (Void)super.visitBlock(block, unused);
            }
        }, null);
        return Description.NO_MATCH;
    }

    Description scanBlock(MethodTree tree, BlockTree block, VisitorState state) {
        PeekingIterator<? extends StatementTree> it = Iterators.peekingIterator(block.getStatements().iterator());
        while (it.hasNext() && !MATCHER.matches(it.peek(), state)) {
            it.next();
        }
        ArrayList<Tree> expectations = new ArrayList<Tree>();
        while (it.hasNext() && MATCHER.matches(it.peek(), state)) {
            expectations.add(it.next());
        }
        if (expectations.isEmpty()) {
            return Description.NO_MATCH;
        }
        ArrayDeque suffix = new ArrayDeque();
        StatementTree failure = null;
        Iterators.addAll(suffix, it);
        if (!suffix.isEmpty() && FAIL_MATCHER.matches((StatementTree)suffix.peekLast(), state)) {
            failure = (StatementTree)suffix.removeLast();
        }
        while (!suffix.isEmpty() && TRUTH_ASSERT_THAT.matches((StatementTree)suffix.peekLast(), state)) {
            suffix.removeLast();
        }
        return this.handleMatch(tree, state, expectations, ImmutableList.copyOf(suffix), failure);
    }

    private Description handleMatch(MethodTree tree, VisitorState state, List<Tree> expectations, List<StatementTree> suffix, @Nullable StatementTree failure) {
        return this.describeMatch(tree, ExpectedExceptionChecker.buildFix(state, expectations, failure, suffix));
    }

    private static Fix buildFix(VisitorState state, List<Tree> expectations, @Nullable StatementTree failure, List<StatementTree> suffix) {
        Type exceptionType = state.getSymtab().throwableType;
        ArrayList<String> newAsserts = new ArrayList<String>();
        SuggestedFix.Builder fix = SuggestedFix.builder();
        block10: for (Tree expectation : expectations) {
            MethodInvocationTree invocation = (MethodInvocationTree)((ExpressionStatementTree)expectation).getExpression();
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(invocation);
            Symtab symtab = state.getSymtab();
            List<? extends ExpressionTree> args = invocation.getArguments();
            switch (((Name)symbol.getSimpleName()).toString()) {
                case "expect": {
                    Type matchType;
                    Type type = ASTHelpers.getType(Iterables.getOnlyElement(invocation.getArguments()));
                    if (ASTHelpers.isSubtype(type, symtab.classType, state)) {
                        exceptionType = ASTHelpers.getUpperBound(Iterables.getFirst(state.getTypes().asSuper(type, symtab.classType.tsym).getTypeArguments(), symtab.throwableType), state.getTypes());
                        continue block10;
                    }
                    if (!ASTHelpers.isSubtype(type, ORG_HAMCREST_MATCHER_TYPE.get(state), state)) continue block10;
                    Type matcherType = state.getTypes().asSuper(type, ORG_HAMCREST_MATCHER_SYMBOL.get(state));
                    if (!matcherType.getTypeArguments().isEmpty() && ASTHelpers.isSubtype(matchType = Iterables.getOnlyElement(matcherType.getTypeArguments()), symtab.throwableType, state)) {
                        exceptionType = matchType;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown, %s);", state.getSourceForNode(Iterables.getOnlyElement(args))));
                    continue block10;
                }
                case "expectCause": {
                    ExpressionTree matcher = Iterables.getOnlyElement(invocation.getArguments());
                    if (IS_A.matches(matcher, state)) {
                        fix.addStaticImport("com.google.common.truth.Truth.assertThat");
                        newAsserts.add(String.format("assertThat(thrown).hasCauseThat().isInstanceOf(%s);", state.getSourceForNode(Iterables.getOnlyElement(((MethodInvocationTree)matcher).getArguments()))));
                        continue block10;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown.getCause(), %s);", state.getSourceForNode(Iterables.getOnlyElement(args))));
                    continue block10;
                }
                case "expectMessage": {
                    if (ASTHelpers.isSubtype((Type)((Symbol.VarSymbol)Iterables.getOnlyElement(symbol.getParameters())).asType(), symtab.stringType, state)) {
                        fix.addStaticImport("com.google.common.truth.Truth.assertThat");
                        newAsserts.add(String.format("assertThat(thrown).hasMessageThat().contains(%s);", state.getSourceForNode(Iterables.getOnlyElement(args))));
                        continue block10;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown.getMessage(), %s);", state.getSourceForNode(Iterables.getOnlyElement(args))));
                    continue block10;
                }
            }
            throw new AssertionError((Object)("unknown expect method: " + (Name)symbol.getSimpleName()));
        }
        fix.replace(ASTHelpers.getStartPosition(expectations.get(0)), state.getEndPosition(Iterables.getLast(expectations)), "");
        if (failure != null) {
            fix.delete(failure);
        }
        return ExpectedExceptionChecker.finishFix(fix.build(), exceptionType, newAsserts, suffix, state);
    }

    private static Fix finishFix(SuggestedFix baseFix, Type exceptionType, List<String> newAsserts, List<StatementTree> throwingStatements, VisitorState state) {
        boolean useExpressionLambda;
        if (throwingStatements.isEmpty()) {
            return baseFix;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder().merge(baseFix);
        fix.addStaticImport("org.junit.Assert.assertThrows");
        StringBuilder fixPrefix = new StringBuilder();
        String exceptionTypeName = SuggestedFixes.qualifyType(state, fix, exceptionType);
        if (!newAsserts.isEmpty()) {
            fixPrefix.append(String.format("%s thrown = ", exceptionTypeName));
        }
        fixPrefix.append("assertThrows");
        fixPrefix.append(String.format("(%s.class, () -> ", exceptionTypeName));
        boolean bl = useExpressionLambda = throwingStatements.size() == 1 && Iterables.getOnlyElement(throwingStatements).getKind() == Tree.Kind.EXPRESSION_STATEMENT;
        if (!useExpressionLambda) {
            fixPrefix.append("{");
        }
        fix.prefixWith(throwingStatements.get(0), fixPrefix.toString());
        if (useExpressionLambda) {
            fix.postfixWith(((ExpressionStatementTree)throwingStatements.get(0)).getExpression(), ")");
            fix.postfixWith(Iterables.getLast(throwingStatements), "\n" + Joiner.on('\n').join(newAsserts));
        } else {
            fix.postfixWith(Iterables.getLast(throwingStatements), "});\n" + Joiner.on('\n').join(newAsserts));
        }
        return fix.build();
    }
}

