/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import java.util.Objects;

@BugPattern(summary="This expression evaluates to 0. If this isn't an error, consider expressing it as a literal 0.", severity=BugPattern.SeverityLevel.WARNING)
public final class ErroneousBitwiseExpression
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    @Override
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (tree.getKind() != Tree.Kind.AND) {
            return Description.NO_MATCH;
        }
        Object constantValue = ASTHelpers.constValue(tree);
        return Objects.equals(constantValue, 0) || Objects.equals(constantValue, 0L) ? this.describeMatch(tree, (Fix)SuggestedFix.replace(state.getEndPosition(tree.getLeftOperand()), ASTHelpers.getStartPosition(tree.getRightOperand()), " | ")) : Description.NO_MATCH;
    }
}

