/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeCompatibilityUtils;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import javax.inject.Inject;

@BugPattern(summary="An equality test between objects with incompatible types always returns false", severity=BugPattern.SeverityLevel.WARNING)
public class EqualsIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final Matcher<ExpressionTree> STATIC_EQUALS_MATCHER = Matchers.staticEqualsInvocation();
    private static final Matcher<ExpressionTree> INSTANCE_EQUALS_MATCHER = Matchers.instanceEqualsInvocation();
    private static final Matcher<Tree> ASSERT_FALSE_MATCHER = Matchers.toType(MethodInvocationTree.class, Matchers.anyOf(Matchers.instanceMethod().anyClass().named("assertFalse"), Matchers.staticMethod().anyClass().named("assertFalse")));
    private final TypeCompatibilityUtils typeCompatibilityUtils;

    @Inject
    public EqualsIncompatibleType(ErrorProneFlags flags) {
        this.typeCompatibilityUtils = TypeCompatibilityUtils.fromFlags(flags);
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree invocationTree, VisitorState state) {
        Type argumentType;
        Type receiverType;
        if (!STATIC_EQUALS_MATCHER.matches(invocationTree, state) && !INSTANCE_EQUALS_MATCHER.matches(invocationTree, state)) {
            return Description.NO_MATCH;
        }
        if (STATIC_EQUALS_MATCHER.matches(invocationTree, state)) {
            receiverType = ASTHelpers.getType(invocationTree.getArguments().get(0));
            argumentType = ASTHelpers.getType(invocationTree.getArguments().get(1));
        } else {
            receiverType = ASTHelpers.getReceiverType(invocationTree);
            argumentType = ASTHelpers.getType(invocationTree.getArguments().get(0));
        }
        return this.handle(invocationTree, receiverType, argumentType, state);
    }

    @Override
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        Type argumentType;
        Type receiverType;
        if (!STATIC_EQUALS_MATCHER.matches(tree, state) && !INSTANCE_EQUALS_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Type type = state.getTypes().findDescriptorType(ASTHelpers.getType(tree));
        if (STATIC_EQUALS_MATCHER.matches(tree, state)) {
            receiverType = type.getParameterTypes().get(0);
            argumentType = type.getParameterTypes().get(1);
        } else {
            receiverType = ASTHelpers.getType(ASTHelpers.getReceiver(tree));
            argumentType = type.getParameterTypes().get(0);
        }
        return this.handle(tree, receiverType, argumentType, state);
    }

    private Description handle(ExpressionTree invocationTree, Type receiverType, Type argumentType, VisitorState state) {
        TypeCompatibilityUtils.TypeCompatibilityReport compatibilityReport = this.typeCompatibilityUtils.compatibilityOfTypes(receiverType, argumentType, state);
        if (compatibilityReport.isCompatible()) {
            return Description.NO_MATCH;
        }
        if (ASSERT_FALSE_MATCHER.matches(state.getPath().getParentPath().getLeaf(), state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.getGeneratedBy(state).contains("com.google.auto.value.processor.AutoValueProcessor")) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(invocationTree).setMessage(EqualsIncompatibleType.getMessage(invocationTree, receiverType, argumentType, compatibilityReport.lhs(), compatibilityReport.rhs(), state) + compatibilityReport.extraReason()).build();
    }

    private static String getMessage(ExpressionTree invocationTree, Type receiverType, Type argumentType, Type conflictingReceiverType, Type conflictingArgumentType, VisitorState state) {
        TypeStringPair typeStringPair = new TypeStringPair(receiverType, argumentType);
        String baseMessage = "Calling " + ASTHelpers.getSymbol(invocationTree).getSimpleName() + " on incompatible types " + typeStringPair.getReceiverTypeString() + " and " + typeStringPair.getArgumentTypeString();
        if (state.getTypes().isSameType(receiverType, conflictingReceiverType)) {
            return baseMessage;
        }
        TypeStringPair conflictingTypes = new TypeStringPair(conflictingReceiverType, conflictingArgumentType);
        return baseMessage + ". They are incompatible because " + conflictingTypes.getReceiverTypeString() + " and " + conflictingTypes.getArgumentTypeString() + " are incompatible.";
    }

    private static class TypeStringPair {
        private String receiverTypeString;
        private String argumentTypeString;

        private TypeStringPair(Type receiverType, Type argumentType) {
            this.receiverTypeString = Signatures.prettyType(receiverType);
            this.argumentTypeString = Signatures.prettyType(argumentType);
            if (this.argumentTypeString.equals(this.receiverTypeString)) {
                this.receiverTypeString = receiverType.toString();
                this.argumentTypeString = argumentType.toString();
            }
        }

        private String getReceiverTypeString() {
            return this.receiverTypeString;
        }

        private String getArgumentTypeString() {
            return this.argumentTypeString;
        }
    }
}

