/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

@BugPattern(name="DoNotCall", summary="This method should not be called.", severity=BugPattern.SeverityLevel.ERROR)
public class DoNotCallChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> THREAD_RUN = MethodMatchers.instanceMethod().onDescendantOf("java.lang.Thread").named("run").withNoParameters();
    private static final Matcher<ExpressionTree> CALL_ON_SUPER = (invocation, state) -> {
        if (invocation.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return false;
        }
        ExpressionTree select = ((MethodInvocationTree)invocation).getMethodSelect();
        if (select.getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        ExpressionTree receiver = ((MemberSelectTree)select).getExpression();
        if (receiver.getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        return ((IdentifierTree)receiver).getName().contentEquals("super");
    };
    private static final ImmutableMap<Matcher<ExpressionTree>, String> THIRD_PARTY_METHODS = ImmutableMap.builder().put(MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertEquals").withParameters("double", "double"), "This method always throws java.lang.AssertionError. Use assertEquals(expected, actual, delta) to compare floating-point numbers").put(MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertEquals").withParameters("java.lang.String", "double", "double"), "This method always throws java.lang.AssertionError. Use assertEquals(String, expected, actual, delta) to compare floating-point numbers").put(MethodMatchers.instanceMethod().onExactClass("java.lang.Thread").named("stop").withParameters("java.lang.Throwable", new String[0]), "Thread.stop(Throwable) always throws an UnsupportedOperationException").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.sql.Date").namedAnyOf("getHours", "getMinutes", "getSeconds", "setHours", "setMinutes", "setSeconds")), "The hour/minute/second getters and setters on java.sql.Date are guaranteed to throw IllegalArgumentException because java.sql.Date does not have a time component.").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.sql.Date").named("toInstant")), "sqlDate.toInstant() is not supported. Did you mean to call toLocalDate() instead?").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.sql.Time").namedAnyOf("getYear", "getMonth", "getDay", "getDate", "setYear", "setMonth", "setDate")), "The year/month/day getters and setters on java.sql.Time are guaranteed to throw IllegalArgumentException because java.sql.Time does not have a date component.").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.sql.Time").named("toInstant")), "sqlTime.toInstant() is not supported. Did you mean to call toLocalTime() instead?").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.util.concurrent.ThreadLocalRandom").named("setSeed")), "ThreadLocalRandom does not support setting a seed.").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.util.concurrent.locks.ReentrantReadWriteLock.ReadLock").named("newCondition")), "ReadLocks do not support conditions.").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.lang.StackTraceElement").named("getClass")), "Calling getClass on StackTraceElement returns the Class object for StackTraceElement, you probably meant to retrieve the class containing the execution point represented by this stack trace element using getClassName").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.lang.StackWalker").named("getClass")), "Calling getClass on StackWalker returns the Class object for StackWalker, you probably meant to retrieve the class containing the execution point represented by this StackWalker using getCallerClass").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.lang.StackWalker$StackFrame").named("getClass")), "Calling getClass on StackFrame returns the Class object for StackFrame, you probably meant to retrieve the class containing the execution point represented by this StackFrame using getClassName").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.lang.reflect.Constructor").named("getClass")), "Calling getClass on Constructor returns the Class object for Constructor, you probably meant to retrieve the class containing the constructor represented by this Constructor using getDeclaringClass").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.lang.reflect.Field").named("getClass")), "Calling getClass on Field returns the Class object for Field, you probably meant to retrieve the class containing the field represented by this Field using getDeclaringClass").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.lang.reflect.Method").named("getClass")), "Calling getClass on Method returns the Class object for Method, you probably meant to retrieve the class containing the method represented by this Method using getDeclaringClass").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.lang.reflect.ParameterizedType").named("getClass")), "Calling getClass on ParameterizedType returns the Class object for ParameterizedType, you probably meant to retrieve the class containing the method represented by this ParameterizedType using getRawType").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("java.beans.BeanDescriptor").named("getClass")), "Calling getClass on BeanDescriptor returns the Class object for BeanDescriptor, you probably meant to retrieve the class described by this BeanDescriptor using getBeanClass").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onDescendantOf("java.lang.management.LockInfo").named("getClass")), "Calling getClass on LockInfo returns the Class object for LockInfo, you probably meant to retrieve the class of the object that is being locked using getClassName").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onExactClass("com.google.common.reflect.ClassPath$ClassInfo").named("getClass")), "Calling getClass on ClassInfo returns the Class object for ClassInfo, you probably meant to retrieve the class described by this ClassInfo using getName or load").put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.instanceMethod().onDescendantOf("com.google.common.reflect.TypeToken").named("getClass")), "Calling getClass on TypeToken returns the Class object for TypeToken, you probably meant to retrieve the class described by this TypeToken using getRawType").put((MethodMatchers.ParameterMatcher)Matchers.allOf(THREAD_RUN, Matchers.not(CALL_ON_SUPER)), "Calling run on Thread runs work on this thread, rather than the given thread, you probably meant to call start").buildOrThrow();
    static final String DO_NOT_CALL = "com.google.errorprone.annotations.DoNotCall";

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        if (ASTHelpers.hasAnnotation((Tree)tree, DO_NOT_CALL, state)) {
            if (symbol.getModifiers().contains((Object)Modifier.PRIVATE)) {
                return this.buildDescription(tree).setMessage("A private method that should not be called should simply be removed.").build();
            }
            if (symbol.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return Description.NO_MATCH;
            }
            if (!ASTHelpers.methodCanBeOverridden(symbol)) {
                return Description.NO_MATCH;
            }
            return this.buildDescription(tree).setMessage("Methods annotated with @DoNotCall should be final or static.").addFix(SuggestedFixes.addModifiers((Tree)tree, state, Modifier.FINAL).orElse(SuggestedFix.emptyFix())).build();
        }
        return ASTHelpers.findSuperMethods(symbol, state.getTypes()).stream().filter(s2 -> ASTHelpers.hasAnnotation((Symbol)s2, DO_NOT_CALL, state)).findAny().map(s2 -> {
            String message = String.format("Method overrides %s in %s which is annotated @DoNotCall, it should also be annotated.", s2.getSimpleName(), s2.owner.getSimpleName());
            return this.buildDescription(tree).setMessage(message).addFix(SuggestedFix.builder().addImport(DO_NOT_CALL).prefixWith(tree, "@DoNotCall ").build()).build();
        }).orElse(Description.NO_MATCH);
    }

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        final ImmutableListMultimap<Symbol.VarSymbol, Type> assignedTypes = this.getAssignedTypes(state);
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                this.handleTree(tree, ASTHelpers.getSymbol(tree));
                return (Void)super.visitMethodInvocation(tree, null);
            }

            @Override
            public Void visitMemberReference(MemberReferenceTree tree, Void unused) {
                this.handleTree(tree, ASTHelpers.getSymbol(tree));
                return (Void)super.visitMemberReference(tree, null);
            }

            private void handleTree(ExpressionTree tree, Symbol.MethodSymbol symbol) {
                for (Map.Entry matcher : THIRD_PARTY_METHODS.entrySet()) {
                    if (!((Matcher)matcher.getKey()).matches(tree, this.state)) continue;
                    this.state.reportMatch(DoNotCallChecker.this.buildDescription(tree).setMessage((String)matcher.getValue()).build());
                    return;
                }
                this.checkTree(tree, symbol, this.state);
            }

            private void checkTree(ExpressionTree tree, Symbol.MethodSymbol sym, VisitorState state) {
                this.mustNotCall(tree, sym, state).ifPresent(symbol -> this.handleDoNotCall(tree, (Symbol)symbol, state));
            }

            private void handleDoNotCall(ExpressionTree tree, Symbol symbol, VisitorState state) {
                String doNotCall = DoNotCallChecker.getDoNotCallValue(symbol);
                StringBuilder message = new StringBuilder("This method should not be called");
                if (doNotCall.isEmpty()) {
                    message.append(", see its documentation for details.");
                } else {
                    message.append(": ").append(doNotCall);
                }
                state.reportMatch(DoNotCallChecker.this.buildDescription(tree).setMessage(message.toString()).build());
            }

            private Optional<Symbol> mustNotCall(ExpressionTree tree, Symbol.MethodSymbol sym, VisitorState state) {
                if (ASTHelpers.hasAnnotation((Symbol)sym, DoNotCallChecker.DO_NOT_CALL, state)) {
                    return Optional.of(sym);
                }
                ExpressionTree receiver = ASTHelpers.getReceiver(tree);
                Symbol receiverSymbol = ASTHelpers.getSymbol(receiver);
                if (!(receiverSymbol instanceof Symbol.VarSymbol)) {
                    return Optional.empty();
                }
                ImmutableCollection assigned = assignedTypes.get((Symbol.VarSymbol)receiverSymbol);
                if (!assigned.stream().allMatch(arg_0 -> 1.lambda$mustNotCall$1((ImmutableList)assigned, state, arg_0))) {
                    return Optional.empty();
                }
                Types types = state.getTypes();
                return assigned.stream().flatMap(typeSeen -> types.closure((Type)typeSeen).stream().flatMap(t2 -> t2.tsym.members() == null ? Stream.empty() : Streams.stream(t2.tsym.members().getSymbolsByName(sym.name))).filter(symbol -> !sym.isStatic() && (sym.flags() & 0x1000L) == 0L && ASTHelpers.hasAnnotation(symbol, DoNotCallChecker.DO_NOT_CALL, state) && symbol.overrides(sym, types.erasure((Type)typeSeen).tsym, types, true))).findFirst();
            }

            private static /* synthetic */ boolean lambda$mustNotCall$1(ImmutableList assigned, VisitorState state, Type t2) {
                return ASTHelpers.isSameType(t2, (Type)assigned.get(0), state);
            }
        }.scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private ImmutableListMultimap<Symbol.VarSymbol, Type> getAssignedTypes(VisitorState state) {
        final ImmutableListMultimap.Builder assignedTypes = ImmutableListMultimap.builder();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitVariable(VariableTree node, Void unused) {
                Type type;
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol(node);
                if (node.getInitializer() != null && ASTHelpers.isConsideredFinal(symbol) && (type = ASTHelpers.getType(node.getInitializer())) != null) {
                    assignedTypes.put(symbol, type);
                }
                return (Void)super.visitVariable(node, null);
            }

            @Override
            public Void visitAssignment(AssignmentTree node, Void unused) {
                Type type;
                Symbol assignee = ASTHelpers.getSymbol(node.getVariable());
                if (assignee instanceof Symbol.VarSymbol && ASTHelpers.isConsideredFinal(assignee) && (type = ASTHelpers.getType(node.getExpression())) != null) {
                    assignedTypes.put((Symbol.VarSymbol)assignee, type);
                }
                return (Void)super.visitAssignment(node, null);
            }
        }.scan(state.getPath(), (Void)null);
        return assignedTypes.build();
    }

    private static String getDoNotCallValue(Symbol symbol) {
        for (Attribute.Compound a : symbol.getRawAttributes()) {
            if (!a.type.tsym.getQualifiedName().contentEquals(DO_NOT_CALL)) continue;
            return MoreAnnotations.getAnnotationValue(a, "value").flatMap(MoreAnnotations::asStringValue).orElse("");
        }
        throw new IllegalStateException();
    }
}

